/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.jboss.ws.jaxrpc.ServiceObjectFactory;
import org.jboss.ws.metadata.j2ee.UnifiedPortComponentRefMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedServiceRefMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedWebMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityConfigurationFactory;
import org.jboss.ws.server.ServiceEndpointManager;
import org.jboss.ws.server.ServiceEndpointManagerFactory;

public class ServiceReferenceable
implements Referenceable {
    public static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";
    public static final String DEPLOYMENT_URL = "DEPLOYMENT_URL";
    public static final String SECURITY_CONFIG = "SECURITY_CONFIG";
    public static final String DESCRIPTOR_LOC = "DESCRIPTOR_LOC";
    public static final String PORT_COMPONENT_LINK = "PORT_COMPONENT_LINK";
    public static final String PORT_COMPONENT_LINK_SERVLET = "PORT_COMPONENT_LINK_SERVLET";
    private UnifiedServiceRefMetaData refMetaData;
    private UnifiedDeploymentInfo udi;

    public ServiceReferenceable(UnifiedServiceRefMetaData refMetaData, UnifiedDeploymentInfo udi) {
        this.refMetaData = refMetaData;
        this.udi = udi;
    }

    public Reference getReference() throws NamingException {
        Reference myRef = new Reference(ServiceReferenceable.class.getName(), ServiceObjectFactory.class.getName(), null);
        URL deploymentURL = this.udi.localUrl != null ? this.udi.localUrl : this.udi.url;
        myRef.add(new StringRefAddr(DEPLOYMENT_URL, deploymentURL.toExternalForm()));
        myRef.add(new BinaryRefAddr(SERVICE_REF_META_DATA, this.marshallServiceRef()));
        if (this.getSecurityConfigURL() != null) {
            myRef.add(new BinaryRefAddr(SECURITY_CONFIG, this.marshallSecurityConfig()));
        }
        UnifiedPortComponentRefMetaData[] pcrArr = this.refMetaData.getPortComponentRefs();
        for (int i = 0; i < pcrArr.length; ++i) {
            UnifiedPortComponentRefMetaData pcr = pcrArr[i];
            String pcLink = pcr.getPortComponentLink();
            if (pcLink == null) continue;
            myRef.add(new StringRefAddr(PORT_COMPONENT_LINK, pcLink));
            try {
                ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
                ServiceEndpointManager epManager = factory.getServiceEndpointManager();
                String host = epManager.getWebServiceHost();
                int port = epManager.getWebServicePort();
                String servletURL = "http://" + host + ":" + port + "/jbossws/pclink";
                myRef.add(new StringRefAddr(PORT_COMPONENT_LINK_SERVLET, servletURL));
                continue;
            }
            catch (Exception ex) {
                throw new NamingException("Cannot obtain path to PortComponentLinkServlet: " + ex);
            }
        }
        return myRef;
    }

    private byte[] marshallServiceRef() throws NamingException {
        this.refMetaData.getJavaWsdlMapping();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.refMetaData);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot marshall service ref meta data, cause: " + e.toString());
        }
        return baos.toByteArray();
    }

    private byte[] marshallSecurityConfig() throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            URL securityURL = this.getSecurityConfigURL();
            WSSecurityConfiguration securityConfig = WSSecurityConfigurationFactory.newInstance().parse(securityURL);
            oos.writeObject(securityConfig);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot marshall security config, cause: " + e.toString());
        }
        return baos.toByteArray();
    }

    private URL getSecurityConfigURL() {
        URLClassLoader ctxClassLoader = this.refMetaData.getResourceCL();
        String descriptorLoc = this.udi.metaData instanceof UnifiedWebMetaData ? "WEB-INF" : "META-INF";
        URL securityURL = ctxClassLoader.getResource(descriptorLoc + "/" + WSSecurityConfigurationFactory.CLIENT_RESOURCE_NAME);
        return securityURL;
    }
}

