/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import java.io.ByteArrayInputStream;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxb.JAXBUnmarshaller;
import org.jboss.ws.jaxb.JBossXBUnmarshallerImpl;
import org.jboss.ws.jaxrpc.encoding.DeserializerSupport;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;

public class JAXBDeserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(JAXBDeserializer.class);
    private JAXBUnmarshaller unmarshaller = new JBossXBUnmarshallerImpl();

    public Object deserialize(QName xmlName, QName xmlType, String val, SerializationContextImpl serContext) throws BindingException {
        log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        Object value = null;
        String typeName = xmlType.getLocalPart();
        try {
            XSModel model = serContext.getXsModel();
            JavaWsdlMapping jaxrpcMapping = serContext.getJavaWsdlMapping();
            this.unmarshaller.setProperty("org.jboss.jaxb.xsd.xsmodel", model);
            this.unmarshaller.setProperty("org.jboss.jaxb.root.qname", xmlName);
            this.unmarshaller.setProperty("org.jboss.jaxb.type.qname", xmlType);
            this.unmarshaller.setProperty("org.jboss.jaxb.java.mapping", jaxrpcMapping);
            ByteArrayInputStream ins = new ByteArrayInputStream(val.getBytes("UTF-8"));
            value = this.unmarshaller.unmarshal(ins);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
        log.debug((Object)("deserialized: " + (value != null ? value.getClass().getName() : null)));
        return value;
    }
}

