/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Serializer;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class SerializerSupport
implements Serializer {
    public abstract String serialize(QName var1, QName var2, Object var3, SerializationContextImpl var4, NamedNodeMap var5) throws BindingException;

    protected String wrapValueStr(QName xmlName, String valueStr, NamespaceRegistry nsRegistry, NamedNodeMap attributes) {
        String xmlFragment;
        String elName;
        String nsURI = xmlName.getNamespaceURI();
        String localPart = xmlName.getLocalPart();
        String prefix = xmlName.getPrefix();
        StringBuilder nsAttr = new StringBuilder("");
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                String attrName = attr.getNodeName();
                String attrValue = attr.getNodeValue();
                nsAttr.append(" " + attrName + "='" + attrValue + "'");
            }
        }
        if (nsURI.length() > 0) {
            xmlName = nsRegistry.registerQName(xmlName);
            prefix = xmlName.getPrefix();
            elName = prefix + ":" + localPart;
            String xmlns = " xmlns:" + prefix + "='" + nsURI + "'";
            if (nsAttr.indexOf(xmlns) < 0) {
                nsAttr.append(xmlns);
            }
        } else {
            elName = localPart;
        }
        if (valueStr == null) {
            xmlFragment = "<" + elName + nsAttr + " xsi:nil='1'/>";
        } else {
            valueStr = this.normalize(valueStr);
            xmlFragment = "<" + elName + nsAttr + ">" + valueStr + "</" + elName + ">";
        }
        return xmlFragment;
    }

    public String getMechanismType() {
        throw new NotImplementedException();
    }

    private String normalize(String valueStr) {
        int i;
        boolean found = false;
        block9: for (i = 0; i < valueStr.length(); ++i) {
            switch (valueStr.charAt(i)) {
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    found = true;
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (!found) {
            return valueStr;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(valueStr.substring(0, i));
        while (i < valueStr.length()) {
            char c = valueStr.charAt(i);
            switch (c) {
                case '<': {
                    builder.append("&lt;");
                    break;
                }
                case '>': {
                    builder.append("&gt;");
                    break;
                }
                case '&': {
                    builder.append("&amp;");
                    break;
                }
                case '\"': {
                    builder.append("&quot;");
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
        return builder.toString();
    }
}

