/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.jaxrpc.encoding.SerializerSupport;
import org.jboss.ws.xop.XOPMarshallerImpl;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.NamedNodeMap;

public class SimpleSerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(SimpleSerializer.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String serialize(QName xmlName, QName xmlType, Object value, SerializationContextImpl serContext, NamedNodeMap attributes) throws BindingException {
        String valueStr;
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        String typeName = xmlType.getLocalPart();
        NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
        XOPMarshallerImpl attachmentMarshaller = new XOPMarshallerImpl();
        if (attachmentMarshaller.isXOPPackage() && "base64Binary".equals(typeName)) {
            if (!(value instanceof byte[])) throw new IllegalArgumentException("Unable to apply MTOM to " + value.getClass());
            valueStr = attachmentMarshaller.addMtomAttachment((byte[])value, xmlName.getNamespaceURI(), xmlName.getLocalPart());
            return this.wrapValueStr(xmlName, valueStr, nsRegistry, attributes);
        } else {
            valueStr = SimpleTypeBindings.marshal((String)xmlType.getLocalPart(), (Object)value, (NamespaceContext)nsRegistry);
        }
        return this.wrapValueStr(xmlName, valueStr, nsRegistry, attributes);
    }
}

