/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.config.WSClientConfig;
import org.jboss.ws.metadata.config.WSConfig;
import org.jboss.ws.metadata.config.WSConfigFactory;
import org.jboss.ws.metadata.config.WSHandlerChainConfig;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientEndpointMetaData
extends EndpointMetaData {
    private static Logger log = Logger.getLogger(ClientEndpointMetaData.class);
    private WSClientConfig clientConfig;

    public ClientEndpointMetaData(ServiceMetaData service, QName qname) {
        super(service, qname);
    }

    @Override
    public void setConfigName(String configName) {
        super.setConfigName(configName);
        this.clientConfig = null;
    }

    @Override
    public void setConfigFile(String configFile) {
        super.setConfigFile(configFile);
        this.clientConfig = null;
    }

    public WSClientConfig getClientConfig() {
        if (this.clientConfig == null) {
            WSConfig wsConfig;
            ClassLoader cl;
            String configFile;
            String configName = this.getConfigName();
            if (configName == null) {
                configName = "Standard Client";
                this.setConfigName(configName);
            }
            if ((configFile = this.getConfigFile()) == null) {
                configFile = "META-INF/standard-jbossws-client-config.xml";
                this.setConfigFile(configFile);
            }
            log.debug((Object)("getClientConfig: [name=" + configName + ",url=" + configFile + "]"));
            URL configURL = null;
            try {
                configURL = new URL(configFile);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (configURL == null && (configURL = (cl = Thread.currentThread().getContextClassLoader()).getResource(configFile)) == null) {
                throw new WSException("Cannot get resource: " + configFile);
            }
            try {
                WSConfigFactory factory = WSConfigFactory.newInstance();
                wsConfig = factory.parseWithObjectModelFactory(configURL);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new WSException("Cannot parse client config", ex);
            }
            this.clientConfig = wsConfig.getClientConfigByName(configName);
            if (this.clientConfig == null) {
                throw new WSException("Cannot obtain client config: " + configName);
            }
        }
        return this.clientConfig;
    }

    @Override
    public List<UnifiedHandlerMetaData> getHandlers(UnifiedHandlerMetaData.HandlerType type) {
        WSHandlerChainConfig postHandlerConfig;
        WSHandlerChainConfig preHandlerConfig;
        ArrayList<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>();
        if ((type == UnifiedHandlerMetaData.HandlerType.PRE || type == UnifiedHandlerMetaData.HandlerType.ALL) && (preHandlerConfig = this.getClientConfig().getPreHandlerChain()) != null) {
            handlers.addAll(preHandlerConfig.getHandlers());
        }
        if (type == UnifiedHandlerMetaData.HandlerType.JAXRPC || type == UnifiedHandlerMetaData.HandlerType.ALL) {
            handlers.addAll(super.getHandlers(type));
        }
        if ((type == UnifiedHandlerMetaData.HandlerType.POST || type == UnifiedHandlerMetaData.HandlerType.ALL) && (postHandlerConfig = this.getClientConfig().getPostHandlerChain()) != null) {
            handlers.addAll(postHandlerConfig.getHandlers());
        }
        return handlers;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nClientEndpointMetaData:");
        buffer.append("\n name=" + this.getName());
        buffer.append("\n address=" + this.getEndpointAddress());
        buffer.append("\n seiName=" + this.getServiceEndpointInterfaceName());
        buffer.append("\n configFile=" + this.getConfigFile());
        buffer.append("\n configName=" + this.getConfigName());
        buffer.append("\n authMethod=" + this.getAuthMethod());
        buffer.append("\n transportGuarantee=" + this.getTransportGuarantee());
        buffer.append("\n properties=" + this.getProperties());
        for (OperationMetaData opMetaData : this.getOperations()) {
            buffer.append("\n" + opMetaData);
        }
        for (UnifiedHandlerMetaData hdlMetaData : this.getHandlers(UnifiedHandlerMetaData.HandlerType.ALL)) {
            buffer.append("\n" + hdlMetaData);
        }
        return buffer.toString();
    }
}

