/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.config.WSConfig;
import org.jboss.ws.metadata.config.WSConfigFactory;
import org.jboss.ws.metadata.config.WSEndpointConfig;
import org.jboss.ws.metadata.config.WSHandlerChainConfig;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;
import org.jboss.ws.server.ServiceEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEndpointMetaData
extends EndpointMetaData {
    private static Logger log = Logger.getLogger(ServerEndpointMetaData.class);
    public static final String SEPID_DOMAIN = "jboss.ws";
    public static final String SEPID_PROPERTY_CONTEXT = "context";
    public static final String SEPID_PROPERTY_ENDPOINT = "endpoint";
    private WSEndpointConfig endpointConfig;
    private String linkName;
    private String portComponentName;
    private String implName;
    private ObjectName sepID;
    private String contextRoot;
    private String urlPattern;
    private String managedEndpointBean = ServiceEndpoint.class.getName();
    private boolean annotated = false;

    public ServerEndpointMetaData(ServiceMetaData service, QName qname) {
        super(service, qname);
    }

    @Override
    public void setConfigName(String configName) {
        super.setConfigName(configName);
        this.endpointConfig = null;
    }

    @Override
    public void setConfigFile(String configFile) {
        super.setConfigFile(configFile);
        this.endpointConfig = null;
    }

    public WSEndpointConfig getEndpointConfig() {
        if (this.endpointConfig == null) {
            WSConfig wsConfig;
            ClassLoader cl;
            String configFile;
            String configName = this.getConfigName();
            if (configName == null) {
                configName = "Standard Endpoint";
                this.setConfigName(configName);
            }
            if ((configFile = this.getConfigFile()) == null) {
                configFile = "META-INF/standard-jbossws-endpoint-config.xml";
                this.setConfigFile(configFile);
            }
            log.debug((Object)("getEndpointConfig: [name=" + configName + ",url=" + configFile + "]"));
            URL configURL = null;
            try {
                configURL = new URL(configFile);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (configURL == null && (configURL = (cl = Thread.currentThread().getContextClassLoader()).getResource(configFile)) == null) {
                throw new WSException("Cannot get resource: " + configFile);
            }
            try {
                WSConfigFactory factory = WSConfigFactory.newInstance();
                wsConfig = factory.parseWithObjectModelFactory(configURL);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new WSException("Cannot parse client config", ex);
            }
            this.endpointConfig = wsConfig.getEndpointConfigByName(configName);
            if (this.endpointConfig == null) {
                throw new WSException("Cannot obtain endpoint config: " + configName);
            }
        }
        return this.endpointConfig;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public void setPortComponentName(String portComponentName) {
        this.portComponentName = portComponentName;
    }

    public String getServiceEndpointImplName() {
        return this.implName;
    }

    public void setServiceEndpointImplName(String endpointImpl) {
        this.implName = endpointImpl;
    }

    public ObjectName getServiceEndpointID() {
        return this.sepID;
    }

    public void setServiceEndpointID(ObjectName endpointID) {
        this.sepID = endpointID;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean isAnnotated) {
        this.annotated = isAnnotated;
    }

    public String getManagedEndpointBean() {
        return this.managedEndpointBean;
    }

    public void setManagedEndpointBean(String managedEndpointBean) {
        this.managedEndpointBean = managedEndpointBean;
    }

    @Override
    public List<UnifiedHandlerMetaData> getHandlers(UnifiedHandlerMetaData.HandlerType type) {
        WSHandlerChainConfig postHandlerConfig;
        WSHandlerChainConfig preHandlerConfig;
        ArrayList<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>();
        if ((type == UnifiedHandlerMetaData.HandlerType.PRE || type == UnifiedHandlerMetaData.HandlerType.ALL) && (preHandlerConfig = this.getEndpointConfig().getPreHandlerChain()) != null) {
            handlers.addAll(preHandlerConfig.getHandlers());
        }
        if (type == UnifiedHandlerMetaData.HandlerType.JAXRPC || type == UnifiedHandlerMetaData.HandlerType.ALL) {
            handlers.addAll(super.getHandlers(type));
        }
        if ((type == UnifiedHandlerMetaData.HandlerType.POST || type == UnifiedHandlerMetaData.HandlerType.ALL) && (postHandlerConfig = this.getEndpointConfig().getPostHandlerChain()) != null) {
            handlers.addAll(postHandlerConfig.getHandlers());
        }
        return handlers;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nServerEndpointMetaData:");
        buffer.append("\n name=" + this.getName());
        buffer.append("\n id=" + this.getServiceEndpointID().getCanonicalName());
        buffer.append("\n address=" + this.getEndpointAddress());
        buffer.append("\n linkName=" + this.getLinkName());
        buffer.append("\n implName=" + this.getServiceEndpointImplName());
        buffer.append("\n seiName=" + this.getServiceEndpointInterfaceName());
        buffer.append("\n annotated=" + this.annotated);
        buffer.append("\n portComponentName=" + this.getPortComponentName());
        buffer.append("\n contextRoot=" + this.getContextRoot());
        buffer.append("\n urlPattern=" + this.getURLPattern());
        buffer.append("\n configFile=" + this.getConfigFile());
        buffer.append("\n configName=" + this.getConfigName());
        buffer.append("\n authMethod=" + this.getAuthMethod());
        buffer.append("\n transportGuarantee=" + this.getTransportGuarantee());
        buffer.append("\n properties=" + this.getProperties());
        for (OperationMetaData opMetaData : this.getOperations()) {
            buffer.append("\n" + opMetaData);
        }
        for (UnifiedHandlerMetaData hdlMetaData : this.getHandlers(UnifiedHandlerMetaData.HandlerType.ALL)) {
            buffer.append("\n" + hdlMetaData);
        }
        return buffer.toString();
    }
}

