/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxb.SchemaBindingBuilder;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.TypeMappingRegistryImpl;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.jaxrpc.encoding.JAXBDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.JAXBSerializerFactory;
import org.jboss.ws.jaxrpc.encoding.SOAPArrayDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.SOAPArraySerializerFactory;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLDefinitionsFactory;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.utils.JavaUtils;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMetaData {
    private static final Logger log = Logger.getLogger(ServiceMetaData.class);
    private UnifiedMetaData wsMetaData;
    private Map<QName, EndpointMetaData> endpoints = new LinkedHashMap<QName, EndpointMetaData>();
    private QName name;
    private String wsdName;
    private String wsdlFile;
    private String jaxrpcMappingFile;
    private String wsdlPublishLocation;
    private TypesMetaData types;
    private TypeMappingRegistry tmRegistry = new TypeMappingRegistryImpl();
    private SchemaBinding schemaBinding;
    private Properties properties;
    private Use encStyle;
    private WSSecurityConfiguration securityConfiguration;

    public ServiceMetaData(UnifiedMetaData wsMetaData, QName name) {
        this.wsMetaData = wsMetaData;
        this.name = name;
        this.types = new TypesMetaData(this);
    }

    public UnifiedMetaData getUnifiedMetaData() {
        return this.wsMetaData;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public String getWebserviceDescriptionName() {
        return this.wsdName;
    }

    public void setWebserviceDescriptionName(String wsdName) {
        this.wsdName = wsdName;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public String getWsdlPublishLocation() {
        return this.wsdlPublishLocation;
    }

    public void setWsdlPublishLocation(String wsdlPublishLocation) {
        this.wsdlPublishLocation = wsdlPublishLocation;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public TypesMetaData getTypesMetaData() {
        return this.types;
    }

    public List<EndpointMetaData> getEndpoints() {
        return new ArrayList<EndpointMetaData>(this.endpoints.values());
    }

    public EndpointMetaData getEndpoint(QName portName) {
        return this.endpoints.get(portName);
    }

    public EndpointMetaData getEndpointByServiceEndpointInterface(String seiName) {
        EndpointMetaData epMetaData = null;
        for (EndpointMetaData epmd : this.endpoints.values()) {
            if (!seiName.equals(epmd.getServiceEndpointInterfaceName())) continue;
            if (epMetaData != null) {
                log.warn((Object)("Multiple possible endpoints implementing SEI: " + seiName));
            }
            epMetaData = epmd;
        }
        return epMetaData;
    }

    public void addEndpoint(EndpointMetaData epMetaData) {
        QName portName = epMetaData.getName();
        if (this.endpoints.get(portName) != null) {
            throw new WSException("EndpointMetaData name must be unique: " + portName);
        }
        this.endpoints.put(portName, epMetaData);
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public void setJaxrpcMappingFile(String jaxrpcMappingFile) {
        this.jaxrpcMappingFile = jaxrpcMappingFile;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        JavaWsdlMapping javaWsdlMapping = this.wsMetaData.getMappingDefinition(this.jaxrpcMappingFile);
        if (javaWsdlMapping == null && this.jaxrpcMappingFile != null) {
            URL mappingLocation = null;
            try {
                mappingLocation = new URL(this.jaxrpcMappingFile);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (mappingLocation == null) {
                mappingLocation = this.wsMetaData.getResourceLoader().getResource(this.jaxrpcMappingFile);
            }
            if (mappingLocation == null) {
                throw new IllegalArgumentException("Cannot find jaxrpc-mapping.xml in deployment: " + this.jaxrpcMappingFile);
            }
            try {
                JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
                javaWsdlMapping = mappingFactory.parse(mappingLocation);
                this.wsMetaData.addMappingDefinition(this.jaxrpcMappingFile, javaWsdlMapping);
            }
            catch (IOException e) {
                throw new WSException("Cannot parse jaxrpc-mapping.xml", e);
            }
        }
        return javaWsdlMapping;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        WSDLDefinitions wsdlDefinitions = this.wsMetaData.getWSDLDefinition(this.wsdlFile);
        if (wsdlDefinitions == null && this.wsdlFile != null) {
            URL wsdlLocation = null;
            try {
                wsdlLocation = new URL(this.wsdlFile);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (wsdlLocation == null) {
                wsdlLocation = this.wsMetaData.getResourceLoader().getResource(this.wsdlFile);
            }
            if (wsdlLocation == null) {
                throw new IllegalArgumentException("Cannot find wsdl in deployment: " + this.wsdlFile);
            }
            WSDLDefinitionsFactory factory = WSDLDefinitionsFactory.newInstance();
            wsdlDefinitions = factory.parse(wsdlLocation);
            this.wsMetaData.addWSDLDefinition(this.wsdlFile, wsdlDefinitions);
        }
        return wsdlDefinitions;
    }

    public TypeMappingImpl getTypeMapping() {
        Use encStyle = this.getEncodingStyle();
        TypeMappingImpl typeMapping = (TypeMappingImpl)this.tmRegistry.getTypeMapping(encStyle.toURI());
        if (typeMapping == null) {
            throw new WSException("No type mapping for encoding style: " + encStyle);
        }
        return typeMapping;
    }

    public WSSecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(WSSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public Use getEncodingStyle() {
        if (this.encStyle == null) {
            if (this.endpoints.size() > 0) {
                for (EndpointMetaData epMetaData : this.endpoints.values()) {
                    if (this.encStyle == null) {
                        this.encStyle = epMetaData.getEncodingStyle();
                        continue;
                    }
                    if (this.encStyle.equals(epMetaData.getEncodingStyle())) continue;
                    throw new WSException("Conflicting encoding styles not supported");
                }
            } else {
                this.encStyle = Use.getDefaultUse();
            }
        }
        return this.encStyle;
    }

    public SchemaBinding getSchemaBinding() {
        JavaWsdlMapping wsdlMapping = this.getJavaWsdlMapping();
        if (this.schemaBinding == null && this.getEncodingStyle() == Use.LITERAL && wsdlMapping != null) {
            JBossXSModel xsModel = this.types.getSchemaModel();
            SchemaBindingBuilder bindingBuilder = new SchemaBindingBuilder();
            this.schemaBinding = bindingBuilder.buildSchemaBinding(xsModel, wsdlMapping);
        }
        return this.schemaBinding;
    }

    public void eagerInitialize() {
        JBossXSModel model;
        WSDLTypes types;
        WSDLDefinitions definitions = this.getWsdlDefinitions();
        if (definitions != null && (types = definitions.getWsdlTypes()) != null && (model = types.getSchemaModel()) != null) {
            model.eagerInitialize();
        }
        this.getJavaWsdlMapping();
        TypeMappingImpl typeMapping = this.getTypeMapping();
        for (TypeMappingMetaData tmMetaData : this.getTypesMetaData().getTypeMappings()) {
            Class registeredType;
            String javaTypeName = tmMetaData.getJavaTypeName();
            QName xmlType = tmMetaData.getXmlType();
            if (xmlType == null || (registeredType = typeMapping.getJavaType(xmlType)) != null && registeredType.getName().equals(javaTypeName)) continue;
            ClassLoader classLoader = this.getUnifiedMetaData().getClassLoader();
            if (classLoader == null) {
                throw new WSException("ClassLoader not available in meta data");
            }
            try {
                Class javaType = JavaUtils.loadJavaType(javaTypeName, classLoader);
                if (JavaUtils.isPrimitive(javaTypeName)) {
                    javaType = JavaUtils.getWrapperType(javaType);
                }
                if (this.getEncodingStyle() == Use.ENCODED && javaType.isArray()) {
                    typeMapping.register(javaType, xmlType, new SOAPArraySerializerFactory(), new SOAPArrayDeserializerFactory());
                    continue;
                }
                typeMapping.register(javaType, xmlType, new JAXBSerializerFactory(), new JAXBDeserializerFactory());
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("Cannot load class for type: " + xmlType + "," + javaTypeName));
            }
        }
        for (EndpointMetaData epMetaData : this.endpoints.values()) {
            epMetaData.eagerInitialize();
        }
        this.getSchemaBinding();
    }

    public void assertTargetNamespace(String targetNS) {
        if (!this.getName().getNamespaceURI().equals(targetNS)) {
            throw new WSException("Requested namespace is not WSDL target namespace: " + targetNS);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nServiceMetaData:");
        buffer.append("\n name=" + this.name);
        buffer.append("\n wsdName=" + this.wsdName);
        buffer.append("\n wsdlFile=" + this.wsdlFile);
        buffer.append("\n jaxrpcFile=" + this.jaxrpcMappingFile);
        buffer.append("\n publishLocation=" + this.wsdlPublishLocation);
        buffer.append("\n properties=" + this.properties);
        buffer.append("\n" + this.types);
        for (EndpointMetaData epMetaData : this.endpoints.values()) {
            buffer.append("\n" + epMetaData);
        }
        return buffer.toString();
    }
}

