/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilder;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.metadata.wsdl.WSDL11Reader;
import org.jboss.ws.metadata.wsdl.WSDL20Reader;
import org.jboss.ws.metadata.wsdl.WSDL20Writer;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLException;
import org.jboss.ws.metadata.wsdl.WSDLLocatorImpl;
import org.jboss.ws.utils.JBossWSEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class WSDLDefinitionsFactory {
    private static final Logger log = Logger.getLogger(WSDLDefinitionsFactory.class);
    public static final String FEATURE_IMPORT_DOCUMENTS = "javax.wsdl.importDocuments";
    public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
    private Map features = new HashMap();

    private WSDLDefinitionsFactory() {
    }

    public static WSDLDefinitionsFactory newInstance() {
        return new WSDLDefinitionsFactory();
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        this.features.put(name, new Boolean(value));
    }

    public WSDLDefinitions parse(URL wsdlLocation) throws WSDLException {
        if (wsdlLocation == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        log.debug((Object)("parse: " + wsdlLocation.toExternalForm()));
        JBossWSEntityResolver entityResolver = new JBossWSEntityResolver();
        WSDLDefinitions wsdlDefinitions = null;
        try {
            Document wsdlDoc = this.getDocument(wsdlLocation);
            String defaultNamespace = this.getDefaultNamespace(wsdlDoc);
            if ("http://www.w3.org/2003/11/wsdl".equals(defaultNamespace)) {
                WSDL20Reader wsdlReader = new WSDL20Reader();
                for (Map.Entry entry : this.features.entrySet()) {
                    String key = (String)entry.getKey();
                    Boolean flag = (Boolean)entry.getValue();
                    wsdlReader.setFeature(key, flag);
                }
                wsdlDefinitions = wsdlReader.readWSDL(new WSDLLocatorImpl((EntityResolver)((Object)entityResolver), wsdlLocation));
                wsdlDefinitions.setWsdlDocument(wsdlDoc);
            } else if ("http://schemas.xmlsoap.org/wsdl/".equals(defaultNamespace)) {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
                wsdlReader.setFeature(FEATURE_VERBOSE, false);
                for (Map.Entry entry : this.features.entrySet()) {
                    String key = (String)entry.getKey();
                    Boolean flag = (Boolean)entry.getValue();
                    wsdlReader.setFeature(key, flag.booleanValue());
                }
                ((WSDLReaderImpl)wsdlReader).setEntityResolver((EntityResolver)((Object)entityResolver));
                Definition definition = wsdlReader.readWSDL((WSDLLocator)new WSDLLocatorImpl((EntityResolver)((Object)entityResolver), wsdlLocation));
                wsdlDefinitions = new WSDL11Reader().processDefinition(definition, wsdlLocation);
                wsdlDefinitions.setWsdlDocument(wsdlDoc);
            } else {
                throw new WSDLException("Invalid default namespace: " + defaultNamespace);
            }
            if (log.isTraceEnabled()) {
                StringWriter stwr = new StringWriter();
                WSDL20Writer wsdl20Writer = new WSDL20Writer(wsdlDefinitions);
                wsdl20Writer.write(stwr);
                log.trace((Object)("\n" + stwr.toString()));
            }
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSDLException(e);
        }
        return wsdlDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument(URL wsdlLocation) throws WSDLException {
        Document document;
        InputStream wsdlInputStream = wsdlLocation.openStream();
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder();
            document = builder.parse(wsdlInputStream);
        }
        catch (Throwable throwable) {
            try {
                wsdlInputStream.close();
                throw throwable;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new WSDLException(e);
            }
        }
        wsdlInputStream.close();
        return document;
    }

    private String getDefaultNamespace(Document wsdlDoc) throws WSDLException {
        Element root = wsdlDoc.getDocumentElement();
        String defaultNamespace = root.getNamespaceURI();
        return defaultNamespace;
    }
}

