/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.WSDLDefinitionsFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class WSDLLocatorImpl
implements WSDLLocator {
    private static final Logger log = Logger.getLogger(WSDLDefinitionsFactory.class);
    private EntityResolver entityResolver;
    private URL wsdlURL;
    private String latestImportURI;

    public WSDLLocatorImpl(EntityResolver entityResolver, URL wsdlFile) {
        if (wsdlFile == null) {
            throw new IllegalArgumentException("WSDL file argument cannot be null");
        }
        this.entityResolver = entityResolver;
        this.wsdlURL = wsdlFile;
    }

    public InputSource getBaseInputSource() {
        log.trace((Object)("getBaseInputSource [wsdlUrl=" + this.wsdlURL + "]"));
        try {
            InputStream is = this.wsdlURL.openStream();
            if (is == null) {
                throw new IllegalArgumentException("Cannot obtain wsdl from [" + this.wsdlURL + "]");
            }
            return new InputSource(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot access wsdl from [" + this.wsdlURL + "], " + e.getMessage());
        }
    }

    public String getBaseURI() {
        return this.wsdlURL.toExternalForm();
    }

    public InputSource getImportInputSource(String parent, String resource) {
        log.trace((Object)("getImportInputSource [parent=" + parent + ",resource=" + resource + "]"));
        URL parentURL = null;
        try {
            parentURL = new URL(parent);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Not a valid URL: " + parent));
            return null;
        }
        String wsdlImport = null;
        String external = parentURL.toExternalForm();
        if (resource.startsWith("http://") || resource.startsWith("https://")) {
            wsdlImport = resource;
        } else if (resource.startsWith("/")) {
            String beforePath = external.substring(0, external.indexOf(parentURL.getPath()));
            wsdlImport = beforePath + resource;
        } else {
            String parentDir = external.substring(0, external.lastIndexOf("/"));
            while (resource.startsWith("./")) {
                resource = resource.substring(2);
            }
            while (resource.startsWith("../")) {
                parentDir = parentDir.substring(0, parentDir.lastIndexOf("/"));
                resource = resource.substring(3);
            }
            wsdlImport = parentDir + "/" + resource;
        }
        try {
            log.trace((Object)("Trying to resolve: " + wsdlImport));
            InputSource inputSource = this.entityResolver.resolveEntity(wsdlImport, wsdlImport);
            if (inputSource == null) {
                throw new IllegalArgumentException("Cannot resolve imported resource: " + wsdlImport);
            }
            this.latestImportURI = wsdlImport;
            return inputSource;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException("Cannot access imported wsdl [" + wsdlImport + "], " + e.getMessage());
        }
    }

    public String getLatestImportURI() {
        return this.latestImportURI;
    }
}

