/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.server;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.ws.server.ServiceEndpointManager;
import org.jboss.ws.server.ServiceEndpointManagerFactory;

public class ContextServlet
extends HttpServlet {
    protected final Logger log = Logger.getLogger(ContextServlet.class);
    protected ServiceEndpointManager epManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initServiceEndpointManager();
    }

    protected void initServiceEndpointManager() {
        ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
        this.epManager = factory.getServiceEndpointManager();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter writer = res.getWriter();
        res.setContentType("text/html");
        writer.print("<html>");
        this.setupHTMLResponseHeader(writer);
        writer.print("<body>");
        writer.print(this.epManager.showServiceEndpointTable());
        writer.print("</body>");
        writer.print("</html>");
        writer.close();
    }

    private void setupHTMLResponseHeader(PrintWriter writer) {
        Package wsPackage = Package.getPackage("org.jboss.ws");
        writer.println("<head>");
        writer.println("<meta http-equiv='Content-Type content='text/html; charset=iso-8859-1'>");
        writer.println("<title>JBossWS / " + wsPackage.getImplementationVersion() + "</title>");
        writer.println("<link rel='stylesheet' href='./styles.css'>");
        writer.println("</head>");
    }
}

