/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.binding.BindingProvider;
import org.jboss.ws.binding.BindingProviderRegistry;
import org.jboss.ws.binding.EndpointInvocation;
import org.jboss.ws.handler.HandlerChainBaseImpl;
import org.jboss.ws.handler.ServerHandlerChain;
import org.jboss.ws.jaxrpc.SOAPFaultExceptionHelper;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;
import org.jboss.ws.server.ServiceEndpointInfo;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.jboss.ws.utils.JavaUtils;

public abstract class ServiceEndpointInvoker {
    private static Logger log = Logger.getLogger(ServiceEndpointInvoker.class);
    protected ObjectName objectName;

    public abstract void initServiceEndpoint(ServiceEndpointInfo var1) throws ServiceException;

    public abstract Class loadServiceEndpoint(ServiceEndpointInfo var1) throws ServiceException, ClassNotFoundException;

    public abstract Object createServiceEndpoint(ServiceEndpointInfo var1, Object var2, Class var3) throws IllegalAccessException, InstantiationException, ServiceException;

    public SOAPMessage invoke(ServiceEndpointInfo seInfo, Object endpointContext) throws Exception {
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
        SOAPMessageImpl reqMessage = (SOAPMessageImpl)msgContext.getMessage();
        Class seImpl = this.loadServiceEndpoint(seInfo);
        Object seInstance = this.createServiceEndpoint(seInfo, endpointContext, seImpl);
        try {
            SOAPMessage resMessage;
            boolean oneway = false;
            boolean handlersPass = this.callRequestHandlerChain(seInfo, UnifiedHandlerMetaData.HandlerType.PRE);
            handlersPass = handlersPass && this.callRequestHandlerChain(seInfo, UnifiedHandlerMetaData.HandlerType.JAXRPC);
            boolean bl = handlersPass = handlersPass && this.callRequestHandlerChain(seInfo, UnifiedHandlerMetaData.HandlerType.POST);
            if (handlersPass) {
                BindingProvider bindingProvider = BindingProviderRegistry.getDefaultProvider();
                OperationMetaData opMetaData = this.getDispatchDestination(epMetaData, reqMessage);
                msgContext.setOperationMetaData(opMetaData);
                oneway = opMetaData.isOneWayOperation();
                EndpointInvocation epInv = bindingProvider.unbindRequestMessage(opMetaData, reqMessage);
                this.invokeServiceEndpoint(seInfo, seInstance, epInv);
                SOAPMessage resMessage2 = bindingProvider.bindResponseMessage(opMetaData, epInv);
                msgContext.setMessage(resMessage2);
            }
            if (!oneway) {
                handlersPass = this.callResponseHandlerChain(seInfo, UnifiedHandlerMetaData.HandlerType.POST);
                handlersPass = handlersPass && this.callResponseHandlerChain(seInfo, UnifiedHandlerMetaData.HandlerType.JAXRPC);
                handlersPass = handlersPass && this.callResponseHandlerChain(seInfo, UnifiedHandlerMetaData.HandlerType.PRE);
            }
            SOAPMessage sOAPMessage = resMessage = msgContext.getMessage();
            return sOAPMessage;
        }
        catch (Exception ex) {
            try {
                SOAPMessage faultMessage = SOAPFaultExceptionHelper.exceptionToFaultMessage(ex);
                msgContext.setMessage(faultMessage);
                boolean handlersPass = this.callFaultHandlerChain(seInfo, UnifiedHandlerMetaData.HandlerType.POST, ex);
                handlersPass = handlersPass && this.callFaultHandlerChain(seInfo, UnifiedHandlerMetaData.HandlerType.JAXRPC, ex);
                handlersPass = handlersPass && this.callFaultHandlerChain(seInfo, UnifiedHandlerMetaData.HandlerType.PRE, ex);
            }
            catch (Exception subEx) {
                log.warn((Object)"Cannot process handlerChain.handleFault, ignoring: ", (Throwable)subEx);
            }
            throw ex;
        }
        finally {
            this.destroyServiceEndpoint(seInfo, seInstance);
        }
    }

    private OperationMetaData getDispatchDestination(EndpointMetaData epMetaData, SOAPMessageImpl reqMessage) throws SOAPException {
        OperationMetaData opMetaData = reqMessage.getOperationMetaData(epMetaData);
        SOAPHeader soapHeader = reqMessage.getSOAPHeader();
        if (opMetaData == null) {
            SOAPBody soapBody = reqMessage.getSOAPBody();
            SOAPBodyElement soapBodyElement = (SOAPBodyElement)soapBody.getChildElements().next();
            Name soapName = soapBodyElement.getElementName();
            if (soapHeader != null && soapHeader.examineMustUnderstandHeaderElements("http://schemas.xmlsoap.org/soap/actor/next").hasNext()) {
                QName faultCode = Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND;
                String faultString = "Endpoint " + epMetaData.getName() + " does not contain operation meta data for: " + soapName;
                throw new SOAPFaultException(faultCode, faultString, null, null);
            }
            QName faultCode = Constants.SOAP11_FAULT_CODE_CLIENT;
            String faultString = "Endpoint " + epMetaData.getName() + " does not contain operation meta data for: " + soapName;
            throw new SOAPFaultException(faultCode, faultString, null, null);
        }
        return opMetaData;
    }

    protected Method getImplMethod(Class implClass, Method seiMethod) throws ClassNotFoundException, NoSuchMethodException {
        String methodName = seiMethod.getName();
        Class<?>[] paramTypes = seiMethod.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class paramType = paramTypes[i];
            if (JavaUtils.isPrimitive(paramType)) continue;
            String paramTypeName = paramType.getName();
            paramTypes[i] = paramType = JavaUtils.loadJavaType(paramTypeName);
        }
        Method implMethod = implClass.getMethod(methodName, paramTypes);
        return implMethod;
    }

    protected boolean callRequestHandlerChain(ServiceEndpointInfo seInfo, UnifiedHandlerMetaData.HandlerType type) {
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        boolean status = true;
        String[] roles = null;
        ServerHandlerChain handlerChain = null;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            handlerChain = seInfo.getPreHandlerChain();
        } else if (type == UnifiedHandlerMetaData.HandlerType.JAXRPC) {
            handlerChain = seInfo.getJaxRpcHandlerChain();
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            handlerChain = seInfo.getPostHandlerChain();
        }
        if (handlerChain != null) {
            roles = handlerChain.getRoles();
            status = handlerChain.handleRequest(msgContext);
        }
        if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            HandlerChainBaseImpl.checkMustUnderstand(msgContext, roles);
        }
        return status;
    }

    protected boolean callResponseHandlerChain(ServiceEndpointInfo seInfo, UnifiedHandlerMetaData.HandlerType type) {
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        ServerHandlerChain handlerChain = null;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            handlerChain = seInfo.getPreHandlerChain();
        } else if (type == UnifiedHandlerMetaData.HandlerType.JAXRPC) {
            handlerChain = seInfo.getJaxRpcHandlerChain();
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            handlerChain = seInfo.getPostHandlerChain();
        }
        return handlerChain != null ? handlerChain.handleResponse(msgContext) : true;
    }

    protected boolean callFaultHandlerChain(ServiceEndpointInfo seInfo, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        ServerHandlerChain handlerChain = null;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            handlerChain = seInfo.getPreHandlerChain();
        } else if (type == UnifiedHandlerMetaData.HandlerType.JAXRPC) {
            handlerChain = seInfo.getJaxRpcHandlerChain();
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            handlerChain = seInfo.getPostHandlerChain();
        }
        return handlerChain != null ? handlerChain.handleFault(msgContext) : true;
    }

    public abstract void invokeServiceEndpoint(ServiceEndpointInfo var1, Object var2, EndpointInvocation var3) throws SOAPFaultException;

    public abstract void destroyServiceEndpoint(ServiceEndpointInfo var1, Object var2);

    protected void handleInvocationException(Throwable th) throws SOAPFaultException {
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof InvocationTargetException) {
            InvocationTargetException targetException = (InvocationTargetException)th;
            Throwable targetEx = targetException.getTargetException();
            if (targetEx instanceof SOAPFaultException) {
                throw (SOAPFaultException)targetEx;
            }
            String faultString = targetEx.toString();
            SOAPFaultException soapFaultEx = new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, faultString, null, null);
            soapFaultEx.initCause(targetEx);
            throw soapFaultEx;
        }
        if (th instanceof MBeanException) {
            Exception targetEx = ((MBeanException)th).getTargetException();
            if (targetEx instanceof SOAPFaultException) {
                throw (SOAPFaultException)targetEx;
            }
            String faultString = targetEx.toString();
            SOAPFaultException soapFaultEx = new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, faultString, null, null);
            soapFaultEx.initCause(targetEx);
            throw soapFaultEx;
        }
        String faultString = th.toString();
        SOAPFaultException soapFaultEx = new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, faultString, null, null);
        soapFaultEx.initCause(th);
        throw soapFaultEx;
    }
}

