/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.addressing.AddressingConstantsImpl;
import org.jboss.ws.handler.ServerHandlerChain;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;
import org.jboss.ws.server.ServiceEndpoint;
import org.jboss.ws.server.ServiceEndpointInfo;
import org.jboss.ws.server.ServiceEndpointInvoker;
import org.jboss.ws.server.ServiceEndpointManagerMBean;
import org.jboss.ws.server.ServiceEndpointMetrics;
import org.jboss.ws.server.ServletEndpointContextImpl;
import org.jboss.ws.server.ServletHeaderSource;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPConnectionImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.utils.ThreadLocalAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpointManager
implements ServiceEndpointManagerMBean {
    private static final Logger log = Logger.getLogger(ServiceEndpointManager.class);
    public static final String BEAN_NAME = "ServiceEndpointManager";
    private Map<ObjectName, ServiceEndpoint> registry = new ConcurrentHashMap<ObjectName, ServiceEndpoint>();
    private String webServiceHost;
    private int webServicePort;
    private int webServiceSecurePort;
    private boolean alwaysModifySOAPAddress;
    private String serviceEndpointInvokerJSE;
    private String serviceEndpointInvokerEJB21;
    private String serviceEndpointInvokerEJB3;
    private String serviceEndpointInvokerMDB;

    @Override
    public String getWebServiceHost() {
        return this.webServiceHost;
    }

    @Override
    public int getWebServicePort() {
        return this.webServicePort;
    }

    @Override
    public int getWebServiceSecurePort() {
        return this.webServiceSecurePort;
    }

    @Override
    public boolean isAlwaysModifySOAPAddress() {
        return this.alwaysModifySOAPAddress;
    }

    @Override
    public void setWebServiceHost(String host) {
        if ("0.0.0.0".equals(host)) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                host = localHost.getHostName();
            }
            catch (UnknownHostException e) {
                log.error((Object)("Cannot map host: " + host), (Throwable)e);
            }
        }
        this.webServiceHost = host;
    }

    @Override
    public void setWebServicePort(int port) {
        this.webServicePort = port;
    }

    @Override
    public void setWebServiceSecurePort(int port) {
        this.webServiceSecurePort = port;
    }

    @Override
    public void setAlwaysModifySOAPAddress(boolean modify) {
        this.alwaysModifySOAPAddress = modify;
    }

    public String getServiceEndpointInvokerEJB21() {
        return this.serviceEndpointInvokerEJB21;
    }

    public void setServiceEndpointInvokerEJB21(String invoker) {
        this.serviceEndpointInvokerEJB21 = invoker;
    }

    public String getServiceEndpointInvokerEJB3() {
        return this.serviceEndpointInvokerEJB3;
    }

    public void setServiceEndpointInvokerEJB3(String invoker) {
        this.serviceEndpointInvokerEJB3 = invoker;
    }

    public String getServiceEndpointInvokerMDB() {
        return this.serviceEndpointInvokerMDB;
    }

    public void setServiceEndpointInvokerMDB(String invoker) {
        this.serviceEndpointInvokerMDB = invoker;
    }

    public String getServiceEndpointInvokerJSE() {
        return this.serviceEndpointInvokerJSE;
    }

    public void setServiceEndpointInvokerJSE(String invoker) {
        this.serviceEndpointInvokerJSE = invoker;
    }

    public List<ObjectName> getServiceEndpoints() {
        ArrayList<ObjectName> list = new ArrayList<ObjectName>();
        list.addAll(this.registry.keySet());
        return list;
    }

    public ServiceEndpoint getServiceEndpointByID(ObjectName sepID) {
        ServiceEndpoint wsEndpoint = this.registry.get(sepID);
        if (wsEndpoint == null) {
            log.warn((Object)("No ServiceEndpoint found for serviceID: " + sepID));
        }
        return wsEndpoint;
    }

    public ServiceEndpoint resolvePortComponentLink(String pcLink) {
        String pcName = pcLink;
        int hashIndex = pcLink.indexOf("#");
        if (hashIndex > 0) {
            pcName = pcLink.substring(hashIndex + 1);
        }
        ServiceEndpoint serviceEndpoint = null;
        for (ObjectName sepID : this.registry.keySet()) {
            ServiceEndpoint auxEndpoint = this.registry.get(sepID);
            ServiceEndpointInfo sepInfo = auxEndpoint.getServiceEndpointInfo();
            if (!pcName.equals(sepInfo.getServerEndpointMetaData().getPortComponentName())) continue;
            if (serviceEndpoint != null) {
                log.warn((Object)("Multiple service endoints found for: " + pcLink));
                serviceEndpoint = null;
                break;
            }
            serviceEndpoint = auxEndpoint;
        }
        if (serviceEndpoint == null) {
            log.warn((Object)("No ServiceEndpoint found for pcLink: " + pcLink));
        }
        return serviceEndpoint;
    }

    public String showServiceEndpointTable() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Registered Service Endpoints</h3>");
        pw.println("<table>");
        pw.println("<tr><td>ServiceEndpointID</td><td>ServiceEndpointAddress</td><td>&nbsp;</td></tr>");
        for (Map.Entry<ObjectName, ServiceEndpoint> entry : this.registry.entrySet()) {
            ObjectName sepID = entry.getKey();
            ServiceEndpoint wsEndpoint = entry.getValue();
            ServiceEndpointInfo seInfo = wsEndpoint.getServiceEndpointInfo();
            String endpointAddress = seInfo.getServerEndpointMetaData().getEndpointAddress();
            pw.println("<tr><td>" + sepID.getCanonicalName() + "</td><td><a href='" + endpointAddress + "?wsdl'>" + endpointAddress + "?wsdl</a></td></tr>");
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    public ServiceEndpointMetrics getServiceEndpointMetrics(ObjectName sepID) {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        return wsEndpoint != null ? wsEndpoint.getServiceEndpointMetrics() : null;
    }

    public String showServiceEndpointMetrics(ObjectName sepID) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ServiceEndpointMetrics seMetrics = this.getServiceEndpointMetrics(sepID);
        if (seMetrics != null) {
            pw.println("<h3>Service Endpoint Metrics</h3>");
            pw.println("<table>");
            pw.println("<tr><td>EndpointID</td><td>" + seMetrics.getEndpointID() + "</td></tr>");
            pw.println("<tr><td>Start Time</td><td>" + seMetrics.getStartTime() + "</td></tr>");
            pw.println("<tr><td>Stop Time</td><td>" + seMetrics.getStopTime() + "</td></tr>");
            pw.println("<tr><td>Request Count</td><td>" + seMetrics.getRequestCount() + "</td></tr>");
            pw.println("<tr><td>Response Count</td><td>" + seMetrics.getRequestCount() + "</td></tr>");
            pw.println("<tr><td>Fault Count</td><td>" + seMetrics.getResponseCount() + "</td></tr>");
            pw.println("<tr><td>Max Processing Time</td><td>" + seMetrics.getMaxProcessingTime() + "</td></tr>");
            pw.println("<tr><td>Min Processing Time</td><td>" + seMetrics.getMinProcessingTime() + "</td></tr>");
            pw.println("<tr><td>Avg Processing Time</td><td>" + seMetrics.getAverageProcessingTime() + "</td></tr>");
            pw.println("<tr><td>Total Processing Time</td><td>" + seMetrics.getTotalProcessingTime() + "</td></tr>");
            pw.println("</table>");
            pw.close();
        }
        return sw.toString();
    }

    public void processWSDLRequest(ObjectName sepID, OutputStream outStream, URL requestURL, String resourcePath) throws Exception {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot obtain endpoint for: " + sepID);
        }
        wsEndpoint.handleWSDLRequest(outStream, requestURL, resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSOAPRequest(ObjectName sepID, InputStream inStream, OutputStream outStream, Object context) throws Exception {
        SOAPMessageContextImpl msgContext = new SOAPMessageContextImpl();
        MessageContextAssociation.pushMessageContext(msgContext);
        ServletHeaderSource headerSource = null;
        ServletEndpointContextImpl sepContext = null;
        if (context instanceof ServletEndpointContextImpl) {
            sepContext = (ServletEndpointContextImpl)context;
            msgContext.setProperty("javax.xml.ws.servlet.context", sepContext);
            msgContext.setProperty("javax.xml.ws.servlet.request", sepContext.getHttpServletRequest());
            msgContext.setProperty("javax.xml.ws.servlet.response", sepContext.getHttpServletResponse());
            msgContext.setProperty("javax.xml.ws.servlet.session", sepContext.getHttpSession());
            headerSource = new ServletHeaderSource(sepContext.getHttpServletRequest(), sepContext.getHttpServletResponse());
        }
        try {
            boolean isFault;
            ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
            if (wsEndpoint == null) {
                throw new WSException("Cannot obtain endpoint for: " + sepID);
            }
            SOAPMessage resMessage = wsEndpoint.handleRequest(headerSource, sepContext, inStream);
            SOAPPart part = resMessage.getSOAPPart();
            if (part == null) {
                throw new SOAPException("Cannot obtain SOAPPart from response message");
            }
            SOAPEnvelope soapEnv = part.getEnvelope();
            boolean bl = isFault = soapEnv != null && soapEnv.getBody().getFault() != null;
            if (isFault) {
                sepContext.getHttpServletResponse().setStatus(500);
            }
            this.sendResponse(outStream, msgContext, isFault);
        }
        finally {
            outStream.flush();
            outStream.close();
            MessageContextAssociation.popMessageContext();
            ThreadLocalAssociation.clear();
        }
    }

    private void sendResponse(OutputStream outputStream, SOAPMessageContext msgContext, boolean isFault) throws SOAPException, IOException {
        SOAPMessage soapMessage = msgContext.getMessage();
        String wsaTo = null;
        AddressingProperties outProps = (AddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound");
        if (outProps != null && outProps.getTo() != null) {
            AddressingConstantsImpl ADDR = new AddressingConstantsImpl();
            wsaTo = outProps.getTo().getURI().toString();
            if (wsaTo.equals(ADDR.getAnonymousURI())) {
                wsaTo = null;
            }
        }
        if (wsaTo != null) {
            log.debug((Object)("Sending response to addressing destination: " + wsaTo));
            SOAPConnectionImpl con = new SOAPConnectionImpl();
            con.call(soapMessage, wsaTo, true);
        } else {
            soapMessage.writeTo(outputStream);
        }
    }

    public String processSOAPRequest(ObjectName sepID, String inMessage) throws Exception {
        log.debug((Object)("processSOAPRequest: " + sepID));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inMessage.getBytes("UTF-8"));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(512);
        this.processSOAPRequest(sepID, inputStream, outputStream, null);
        String outMsg = new String(outputStream.toByteArray());
        return outMsg;
    }

    private ServiceEndpointInvoker getServiceEndpointInvoker(ServiceEndpointInfo seInfo) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ServiceEndpointInvoker seInvoker = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (seInfo.getType() == ServiceEndpointInfo.Type.JSE) {
            Class<?> seInvokerClass = cl.loadClass(this.serviceEndpointInvokerJSE);
            seInvoker = (ServiceEndpointInvoker)seInvokerClass.newInstance();
        } else if (seInfo.getType() == ServiceEndpointInfo.Type.SLSB21) {
            Class<?> seInvokerClass = cl.loadClass(this.serviceEndpointInvokerEJB21);
            seInvoker = (ServiceEndpointInvoker)seInvokerClass.newInstance();
        } else if (seInfo.getType() == ServiceEndpointInfo.Type.SLSB30) {
            Class<?> seInvokerClass = cl.loadClass(this.serviceEndpointInvokerEJB3);
            seInvoker = (ServiceEndpointInvoker)seInvokerClass.newInstance();
        } else if (seInfo.getType() == ServiceEndpointInfo.Type.MDB21) {
            Class<?> seInvokerClass = cl.loadClass(this.serviceEndpointInvokerMDB);
            seInvoker = (ServiceEndpointInvoker)seInvokerClass.newInstance();
        }
        if (seInvoker == null) {
            throw new WSException("Cannot obtain service endpoint invoker");
        }
        return seInvoker;
    }

    @Override
    public List<HandlerInfo> getHandlerInfos(ObjectName sepID) {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot find service endpoint: " + sepID);
        }
        List<HandlerInfo> handlerInfos = null;
        if (wsEndpoint != null) {
            ServerHandlerChain handlerChain = wsEndpoint.getServiceEndpointInfo().getJaxRpcHandlerChain();
            handlerInfos = handlerChain.getHandlerInfos();
        }
        return handlerInfos;
    }

    @Override
    public void setHandlerInfos(ObjectName sepID, List<HandlerInfo> infos) {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot find service endpoint: " + sepID);
        }
        if (wsEndpoint.getServiceEndpointInfo().getState() != ServiceEndpoint.State.STOPED) {
            throw new WSException("Endpoint expected to be in STOPED state");
        }
        wsEndpoint.initHandlerChain(infos, null, UnifiedHandlerMetaData.HandlerType.JAXRPC);
    }

    public void createServiceEndpoint(ServiceEndpointInfo seInfo) throws Exception {
        ObjectName sepID = seInfo.getServiceEndpointID();
        if (this.registry.get(sepID) != null) {
            throw new WSException("Service already registerd: " + sepID);
        }
        ServiceEndpointInvoker seInvoker = this.getServiceEndpointInvoker(seInfo);
        seInvoker.initServiceEndpoint(seInfo);
        seInfo.setInvoker(seInvoker);
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        ServerEndpointMetaData epMetaData = seInfo.getServerEndpointMetaData();
        String managedEndpointBean = epMetaData.getManagedEndpointBean();
        Class<?> seClass = ctxLoader.loadClass(managedEndpointBean);
        Constructor<?> ctor = seClass.getConstructor(ServiceEndpointInfo.class);
        ServiceEndpoint wsEndpoint = (ServiceEndpoint)ctor.newInstance(seInfo);
        wsEndpoint.create();
        this.registry.put(sepID, wsEndpoint);
        log.debug((Object)("WebService created: " + sepID));
    }

    @Override
    public void startServiceEndpoint(ObjectName sepID) throws Exception {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot find service endpoint: " + sepID);
        }
        wsEndpoint.start();
        ServiceEndpointInfo seInfo = wsEndpoint.getServiceEndpointInfo();
        log.info((Object)("WebService started: " + seInfo.getServerEndpointMetaData().getEndpointAddress()));
    }

    @Override
    public void stopServiceEndpoint(ObjectName sepID) throws Exception {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot find service endpoint: " + sepID);
        }
        wsEndpoint.stop();
        ServiceEndpointInfo seInfo = wsEndpoint.getServiceEndpointInfo();
        log.info((Object)("WebService stopped: " + seInfo.getServerEndpointMetaData().getEndpointAddress()));
    }

    public void destroyServiceEndpoint(ObjectName sepID) throws Exception {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot find service endpoint: " + sepID);
        }
        wsEndpoint.destroy();
        this.registry.remove(sepID);
        ServiceEndpointInfo seInfo = wsEndpoint.getServiceEndpointInfo();
        log.debug((Object)("WebService destroyed: " + seInfo.getServerEndpointMetaData().getEndpointAddress()));
    }

    public void create() throws Exception {
        MBeanServer server = this.getJMXServer();
        if (server != null) {
            log.debug((Object)"Create service endpoint manager");
            server.registerMBean(this, OBJECT_NAME);
        }
    }

    public void destroy() throws Exception {
        MBeanServer server = this.getJMXServer();
        if (server != null) {
            log.debug((Object)"Destroy service endpoint manager");
            server.unregisterMBean(OBJECT_NAME);
        }
    }

    private MBeanServer getJMXServer() {
        MBeanServer server = null;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.size() > 0) {
            server = servers.get(0);
        }
        return server;
    }
}

