/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.server;

import java.io.Serializable;
import java.util.Date;
import javax.management.ObjectName;

public class ServiceEndpointMetrics
implements Serializable {
    private static final long serialVersionUID = -7730514070812711512L;
    private ObjectName endpointID;
    private Date startTime;
    private Date stopTime;
    private long requestCount;
    private long responseCount;
    private long faultCount;
    private long maxProcessingTime;
    private long minProcessingTime;
    private long avgProcessingTime;
    private long totalProcessingTime;

    public ServiceEndpointMetrics(ObjectName endpointID) {
        this.endpointID = endpointID;
    }

    public void start() {
        this.startTime = new Date();
        this.stopTime = null;
        this.requestCount = 0L;
        this.responseCount = 0L;
        this.faultCount = 0L;
        this.maxProcessingTime = 0L;
        this.minProcessingTime = 0L;
        this.avgProcessingTime = 0L;
        this.totalProcessingTime = 0L;
    }

    public void stop() {
        this.stopTime = new Date();
    }

    public long processRequestMessage() {
        ++this.requestCount;
        return System.currentTimeMillis();
    }

    public void processResponseMessage(long beginTime) {
        ++this.responseCount;
        this.processAnyMessage(beginTime);
    }

    public void processFaultMessage(long beginTime) {
        ++this.faultCount;
        this.processAnyMessage(beginTime);
    }

    private void processAnyMessage(long beginTime) {
        if (beginTime > 0L) {
            long procTime = System.currentTimeMillis() - beginTime;
            if (this.minProcessingTime == 0L) {
                this.minProcessingTime = procTime;
            }
            this.maxProcessingTime = Math.max(this.maxProcessingTime, procTime);
            this.minProcessingTime = Math.min(this.minProcessingTime, procTime);
            this.totalProcessingTime += procTime;
            this.avgProcessingTime = this.totalProcessingTime / (this.responseCount + this.faultCount);
        }
    }

    public ObjectName getEndpointID() {
        return this.endpointID;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public long getMinProcessingTime() {
        return this.minProcessingTime;
    }

    public long getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public long getAverageProcessingTime() {
        return this.avgProcessingTime;
    }

    public long getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getFaultCount() {
        return this.faultCount;
    }

    public long getResponseCount() {
        return this.responseCount;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nEndpoint Metrics: " + this.endpointID);
        buffer.append("\n  startTime=" + this.startTime);
        buffer.append("\n  stopTime=" + this.stopTime);
        buffer.append("\n  requestCount=" + this.requestCount);
        buffer.append("\n  responseCount=" + this.responseCount);
        buffer.append("\n  faultCount=" + this.faultCount);
        buffer.append("\n  maxProcessingTime=" + this.maxProcessingTime);
        buffer.append("\n  minProcessingTime=" + this.minProcessingTime);
        buffer.append("\n  avgProcessingTime=" + this.avgProcessingTime);
        buffer.append("\n  totalProcessingTime=" + this.totalProcessingTime);
        return buffer.toString();
    }
}

