/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.WSException;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.server.ServerConfig;
import org.jboss.ws.server.ServerConfigFactory;
import org.jboss.ws.utils.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLFilePublisher {
    private static final Logger log = Logger.getLogger(WSDLFilePublisher.class);
    private UnifiedDeploymentInfo udi;
    private String expLocation;

    public WSDLFilePublisher(UnifiedDeploymentInfo udi) {
        this.udi = udi;
        String archiveName = udi.shortName;
        if (archiveName.endsWith(".jar") || archiveName.endsWith(".ejb3")) {
            this.expLocation = "META-INF/wsdl/";
        } else if (archiveName.endsWith(".war")) {
            this.expLocation = "WEB-INF/wsdl/";
        } else {
            throw new WSException("Can only publish wsdl from WAR or JAR deployment");
        }
    }

    public void publishWsdlFiles(UnifiedMetaData wsMetaData) throws IOException {
        String deploymentName = this.udi.getCanonicalName();
        for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
            String wsdlFile = serviceMetaData.getWsdlFile();
            log.debug((Object)("Publish WSDL file: " + wsdlFile));
            if (wsdlFile == null) continue;
            File targetFile = this.getPublishLocation(deploymentName, serviceMetaData);
            targetFile.getParentFile().mkdirs();
            try {
                Writer fWriter = IOUtils.getCharsetFileWriter(targetFile, "UTF-8");
                WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
                wsdlDefinitions.write(fWriter, "UTF-8");
                URL wsdlPublishURL = targetFile.toURL();
                log.info((Object)("WSDL published to: " + wsdlPublishURL));
                ServerConfigFactory factory = ServerConfigFactory.getInstance();
                ServerConfig config = factory.getServerConfig();
                if (wsdlFile.startsWith(config.getServerTempDir().toURL().toExternalForm())) {
                    new File(wsdlFile).delete();
                }
                serviceMetaData.setWsdlFile(wsdlPublishURL.toExternalForm());
                Definition wsdl11Definition = wsdlDefinitions.getWsdlOneOneDefinition();
                if (wsdl11Definition != null) {
                    this.publishWsdlImports(targetFile.toURL(), wsdl11Definition);
                    Document document = wsdlDefinitions.getWsdlDocument();
                    this.publishSchemaImports(targetFile.toURL(), document.getDocumentElement());
                    continue;
                }
                throw new NotImplementedException("WSDL-2.0 imports");
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new WSException("Cannot publish wsdl to: " + targetFile, e);
            }
        }
    }

    private void publishWsdlImports(URL parentURL, Definition parentDefinition) throws Exception {
        String baseURI = parentURL.toExternalForm();
        Iterator it = parentDefinition.getImports().values().iterator();
        while (it.hasNext()) {
            for (Import wsdlImport : (List)it.next()) {
                String locationURI = wsdlImport.getLocationURI();
                Definition subdef = wsdlImport.getDefinition();
                if (locationURI.startsWith("http://")) continue;
                URL targetURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + locationURI);
                File targetFile = new File(targetURL.getPath());
                targetFile.getParentFile().mkdirs();
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                FileWriter fw = new FileWriter(targetFile);
                wsdlWriter.writeWSDL(subdef, (Writer)fw);
                fw.close();
                log.debug((Object)("WSDL import published to: " + targetURL));
                this.publishWsdlImports(targetURL, subdef);
                Element subdoc = DOMUtils.parse((InputStream)targetURL.openStream());
                this.publishSchemaImports(targetURL, subdoc);
            }
        }
    }

    private void publishSchemaImports(URL parentURL, Element element) throws Exception {
        String baseURI = parentURL.toExternalForm();
        Iterator it = DOMUtils.getChildElements((Node)element);
        while (it.hasNext()) {
            Element childElement = (Element)it.next();
            if ("import".equals(childElement.getLocalName()) || "include".equals(childElement.getLocalName())) {
                InputStream is;
                String schemaLocation = childElement.getAttribute("schemaLocation");
                if (schemaLocation.length() <= 0 || schemaLocation.startsWith("http://")) continue;
                URL xsdURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + schemaLocation);
                File targetFile = new File(xsdURL.getPath());
                targetFile.getParentFile().mkdirs();
                String deploymentName = this.udi.getCanonicalName();
                int index = baseURI.indexOf(deploymentName);
                String resourcePath = baseURI.substring(index + deploymentName.length());
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
                if (resourcePath.length() > 0) {
                    resourcePath = resourcePath + "/";
                }
                if ((is = this.udi.localCl.getResourceAsStream(resourcePath = this.expLocation + resourcePath + schemaLocation)) == null) {
                    throw new IllegalArgumentException("Cannot find schema import in deployment: " + resourcePath);
                }
                FileOutputStream fos = new FileOutputStream(targetFile);
                IOUtils.copyStream(fos, is);
                fos.close();
                is.close();
                log.debug((Object)("XMLSchema import published to: " + xsdURL));
                Element subdoc = DOMUtils.parse((InputStream)xsdURL.openStream());
                this.publishSchemaImports(xsdURL, subdoc);
                continue;
            }
            this.publishSchemaImports(parentURL, childElement);
        }
    }

    public void unpublishWsdlFiles() throws IOException {
        String deploymentDir = this.udi.parent != null ? this.udi.parent.shortName : this.udi.shortName;
        ServerConfig config = ServerConfigFactory.getInstance().getServerConfig();
        File serviceDir = new File(config.getServerDataDir().getCanonicalPath() + "/wsdl/" + deploymentDir);
        this.deleteWsdlPublishDirectory(serviceDir);
    }

    private void deleteWsdlPublishDirectory(File dir) throws IOException {
        String[] files = dir.list();
        for (int i = 0; files != null && i < files.length; ++i) {
            String fileName = files[i];
            File file = new File(dir + "/" + fileName);
            if (file.isDirectory()) {
                this.deleteWsdlPublishDirectory(file);
                continue;
            }
            if (file.delete()) continue;
            log.warn((Object)("Cannot delete published wsdl document: " + file.toURL()));
        }
        dir.delete();
    }

    private File getPublishLocation(String archiveName, ServiceMetaData serviceMetaData) throws IOException {
        File wsdlLocation;
        String publishLocation = serviceMetaData.getWsdlPublishLocation();
        boolean predefinedLocation = publishLocation != null && publishLocation.startsWith("file:");
        File locationFile = null;
        if (!predefinedLocation) {
            ServerConfig config = ServerConfigFactory.getInstance().getServerConfig();
            locationFile = new File(config.getServerDataDir().getCanonicalPath() + "/wsdl/" + archiveName);
        } else {
            try {
                locationFile = new File(new URL(publishLocation).getPath());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid publish location: " + e.getMessage());
            }
        }
        String wsdlFile = serviceMetaData.getWsdlFile();
        if (wsdlFile.startsWith("/")) {
            wsdlFile = wsdlFile.substring(1);
        }
        if (wsdlFile.startsWith(this.expLocation)) {
            wsdlFile = wsdlFile.substring(this.expLocation.length());
            wsdlLocation = new File(locationFile + "/" + wsdlFile);
        } else if (wsdlFile.startsWith("file:/")) {
            wsdlFile = wsdlFile.substring(wsdlFile.lastIndexOf("/") + 1);
            wsdlLocation = new File(locationFile + "/" + wsdlFile);
        } else {
            throw new WSException("Invalid wsdlFile '" + wsdlFile + "', expected in: " + this.expLocation);
        }
        return wsdlLocation;
    }
}

