/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.metadata.EndpointMetaData;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLRequestHandler {
    private Logger log = Logger.getLogger(WSDLRequestHandler.class);
    private EndpointMetaData epMetaData;

    public WSDLRequestHandler(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public Document getDocumentForPath(String hostPath, String requestURI, String resourcePath) throws IOException {
        Document wsdlDoc;
        String wsdlLocation = this.epMetaData.getServiceMetaData().getWsdlFile();
        if (wsdlLocation == null) {
            throw new IllegalStateException("Cannot obtain wsdlFile from endpoint meta data");
        }
        URL wsdlURL = new URL(wsdlLocation);
        if (resourcePath == null) {
            Element wsdlElement = DOMUtils.parse((InputStream)wsdlURL.openStream());
            wsdlDoc = wsdlElement.getOwnerDocument();
        } else {
            String resPath = new File(wsdlURL.getPath()).getParent() + File.separatorChar + resourcePath;
            File resFile = new File(resPath);
            Element wsdlElement = DOMUtils.parse((InputStream)resFile.toURL().openStream());
            wsdlDoc = wsdlElement.getOwnerDocument();
        }
        this.modifyImportLocations(hostPath, requestURI, resourcePath, wsdlDoc.getDocumentElement());
        return wsdlDoc;
    }

    private void modifyImportLocations(String hostPath, String requestURI, String resourcePath, Element element) {
        NodeList nlist = element.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node childNode = nlist.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            String nodeName = childElement.getLocalName();
            if ("import".equals(nodeName) || "include".equals(nodeName)) {
                boolean isAbsolute;
                Attr locationAttr = childElement.getAttributeNode("schemaLocation");
                if (locationAttr == null) {
                    locationAttr = childElement.getAttributeNode("location");
                }
                if (locationAttr == null) continue;
                String orgLocation = locationAttr.getNodeValue();
                boolean bl = isAbsolute = orgLocation.startsWith("http://") || orgLocation.startsWith("https://");
                if (isAbsolute || orgLocation.startsWith(requestURI)) continue;
                String newResourcePath = orgLocation;
                if (resourcePath != null && resourcePath.indexOf("/") > 0) {
                    newResourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/") + 1) + orgLocation;
                }
                String newLocation = hostPath + requestURI + "?wsdl&resource=" + newResourcePath;
                locationAttr.setNodeValue(newLocation);
                this.log.debug((Object)("Mapping import from '" + orgLocation + "' to '" + newLocation + "'"));
                continue;
            }
            this.modifyImportLocations(hostPath, requestURI, resourcePath, childElement);
        }
    }
}

