/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.soap.DetailEntryImpl;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SAAJEnvelopeBuilder;
import org.jboss.ws.soap.SOAPBodyElementDoc;
import org.jboss.ws.soap.SOAPBodyElementMessage;
import org.jboss.ws.soap.SOAPBodyElementRpc;
import org.jboss.ws.soap.SOAPContentElement;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.ws.soap.SOAPFactoryImpl;
import org.jboss.ws.soap.SOAPFaultImpl;
import org.jboss.ws.soap.SOAPHeaderElementImpl;
import org.jboss.ws.soap.SOAPPartImpl;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMEnvelopeBuilder
implements SAAJEnvelopeBuilder {
    private SOAPMessage soapMessage;
    private boolean ignoreParseException = false;
    private Style style = Style.DOCUMENT;

    public void setSOAPMessage(SOAPMessage soapMessage) {
        this.soapMessage = soapMessage;
    }

    public void setIgnoreParseException(boolean ignoreParseException) {
        this.ignoreParseException = ignoreParseException;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public SOAPEnvelope build(InputStream ins) throws IOException, SOAPException {
        Element domEnv = null;
        try {
            domEnv = DOMUtils.parse((InputStream)ins);
        }
        catch (IOException ex) {
            if (this.ignoreParseException) {
                return null;
            }
            throw ex;
        }
        String envNS = domEnv.getNamespaceURI();
        String envPrefix = domEnv.getPrefix();
        SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
        SOAPPartImpl soapPart = (SOAPPartImpl)this.soapMessage.getSOAPPart();
        SOAPEnvelopeImpl soapEnv = new SOAPEnvelopeImpl(soapPart, soapFactory.createElement(domEnv, false));
        NamespaceRegistry namespaceRegistry = soapEnv.getNamespaceRegistry();
        DOMUtils.copyAttributes((Element)soapEnv, (Element)domEnv);
        this.registerNamespaces(namespaceRegistry, soapEnv);
        Element domHeader = DOMUtils.getFirstChildElement((Node)domEnv, (QName)new QName(envNS, "Header"));
        if (domHeader != null) {
            SOAPHeader soapHeader = soapEnv.getHeader();
            DOMUtils.copyAttributes((Element)soapHeader, (Element)domHeader);
            this.registerNamespaces(namespaceRegistry, soapHeader);
            Iterator it = DOMUtils.getChildElements((Node)domHeader);
            while (it.hasNext()) {
                Element srcElement = (Element)it.next();
                String xmlFragment = DOMWriter.printNode((Node)srcElement, (boolean)false);
                NameImpl name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
                SOAPHeaderElementImpl destElement = new SOAPHeaderElementImpl(name);
                soapHeader.addChildElement(destElement);
                destElement.setXMLFragment(xmlFragment);
            }
        }
        Element domBody = DOMUtils.getFirstChildElement((Node)domEnv, (QName)new QName(envNS, "Body"));
        SOAPBody soapBody = soapEnv.getBody();
        DOMUtils.copyAttributes((Element)soapBody, (Element)domBody);
        this.registerNamespaces(namespaceRegistry, soapBody);
        Iterator itBody = DOMUtils.getChildElements((Node)domBody);
        if (itBody.hasNext()) {
            String nsURI;
            String prefix;
            Element domBodyElement = (Element)itBody.next();
            String localName = domBodyElement.getLocalName();
            NameImpl beName = new NameImpl(localName, prefix = domBodyElement.getPrefix(), nsURI = domBodyElement.getNamespaceURI());
            if (((Object)beName).equals(new NameImpl("Fault", envPrefix, envNS))) {
                Element domFaultDetail;
                SOAPFaultImpl soapFault = new SOAPFaultImpl(envNS);
                soapBody.addChildElement(soapFault);
                DOMUtils.copyAttributes((Element)soapFault, (Element)domBodyElement);
                Element domFaultCode = DOMUtils.getFirstChildElement((Node)domBodyElement, (QName)new QName("faultcode"));
                if (domFaultCode == null) {
                    throw new SOAPException("SOAPFault does not contain a <faultcode> element");
                }
                Element domFaultString = DOMUtils.getFirstChildElement((Node)domBodyElement, (QName)new QName("faultstring"));
                if (domFaultString == null) {
                    throw new SOAPException("SOAPFault does not contain a <faultstring> element");
                }
                String faultCode = DOMUtils.getTextContent((Node)domFaultCode);
                soapFault.setFaultCode(faultCode);
                String faultString = DOMUtils.getTextContent((Node)domFaultString);
                soapFault.setFaultString(faultString);
                Element domFaultActor = DOMUtils.getFirstChildElement((Node)domBodyElement, (QName)new QName("faultactor"));
                if (domFaultActor != null) {
                    String faultActor = DOMUtils.getTextContent((Node)domFaultActor);
                    soapFault.setFaultActor(faultActor);
                }
                if ((domFaultDetail = DOMUtils.getFirstChildElement((Node)domBodyElement, (String)"detail")) != null) {
                    Detail detail = soapFault.addDetail();
                    Iterator it = DOMUtils.getChildElements((Node)domFaultDetail);
                    while (it.hasNext()) {
                        Element domElement = (Element)it.next();
                        SOAPElement detailEntry = new DetailEntryImpl(soapFactory.createElement(domElement, true));
                        detailEntry = detail.addChildElement(detailEntry);
                    }
                }
            } else if (this.style == Style.RPC) {
                SOAPBodyElementRpc soapBodyElement = new SOAPBodyElementRpc(beName);
                soapBodyElement = (SOAPBodyElementRpc)soapBody.addChildElement(soapBodyElement);
                DOMUtils.copyAttributes((Element)soapBodyElement, (Element)domBodyElement);
                Iterator itBodyElement = DOMUtils.getChildElements((Node)domBodyElement);
                while (itBodyElement.hasNext()) {
                    Element srcElement = (Element)itBodyElement.next();
                    this.registerNamespacesLocally(srcElement);
                    NameImpl name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
                    SOAPContentElement destElement = new SOAPContentElement(name);
                    soapBodyElement.addChildElement(destElement);
                    String xmlFragment = DOMWriter.printNode((Node)srcElement, (boolean)false);
                    destElement.setXMLFragment(xmlFragment);
                }
            } else if (this.style == Style.DOCUMENT) {
                Element srcElement = domBodyElement;
                this.registerNamespacesLocally(srcElement);
                SOAPBodyElementDoc destElement = new SOAPBodyElementDoc(beName);
                destElement = (SOAPBodyElementDoc)soapBody.addChildElement(destElement);
                String xmlFragment = DOMWriter.printNode((Node)srcElement, (boolean)false);
                destElement.setXMLFragment(xmlFragment);
            } else if (this.style == null) {
                SOAPBodyElementMessage soapBodyElement = new SOAPBodyElementMessage(beName);
                soapBodyElement = (SOAPBodyElementMessage)soapBody.addChildElement(soapBodyElement);
                DOMUtils.copyAttributes((Element)soapBodyElement, (Element)domBodyElement);
                NodeList nlist = domBodyElement.getChildNodes();
                for (int i = 0; i < nlist.getLength(); ++i) {
                    String nodeValue;
                    Node child = nlist.item(i);
                    short childType = child.getNodeType();
                    if (childType == 1) {
                        SOAPElementImpl soapElement = soapFactory.createElement((Element)child, true);
                        soapBodyElement.addChildElement(soapElement);
                        continue;
                    }
                    if (childType == 3) {
                        nodeValue = child.getNodeValue();
                        soapBodyElement.addTextNode(nodeValue);
                        continue;
                    }
                    if (childType == 4) {
                        nodeValue = child.getNodeValue();
                        soapBodyElement.addTextNode(nodeValue);
                        continue;
                    }
                    System.out.println("Ignore child type: " + childType);
                }
            } else {
                throw new WSException("Unsupported message style: " + this.style);
            }
        }
        return soapEnv;
    }

    private void registerNamespacesLocally(Element srcElement) {
        if (srcElement.getPrefix() == null) {
            srcElement.setAttribute("xmlns", srcElement.getNamespaceURI());
        } else {
            srcElement.setAttribute("xmlns:" + srcElement.getPrefix(), srcElement.getNamespaceURI());
        }
    }

    private void registerNamespaces(NamespaceRegistry namespaceRegistry, SOAPElement soapEl) {
        Iterator itNSPrefixes = soapEl.getNamespacePrefixes();
        while (itNSPrefixes.hasNext()) {
            String prefix = (String)itNSPrefixes.next();
            String nsURI = soapEl.getNamespaceURI(prefix);
            namespaceRegistry.registerURI(nsURI, prefix);
        }
    }
}

