/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SAAJEnvelopeBuilder;
import org.jboss.ws.soap.SAAJEnvelopeBuilderFactory;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.jboss.ws.soap.SOAPPartImpl;
import org.jboss.ws.soap.attachment.MultipartRelatedDecoder;
import org.jboss.ws.utils.IOUtils;
import org.jboss.ws.utils.ThreadLocalAssociation;

public class MessageFactoryImpl
extends MessageFactory {
    private static Logger log = Logger.getLogger(MessageFactoryImpl.class);
    private String envelopeURI = "http://schemas.xmlsoap.org/soap/envelope/";
    private Style style;

    public String getEnvelopeURI() {
        return this.envelopeURI;
    }

    public void setEnvelopeURI(String envelopeURI) {
        this.envelopeURI = envelopeURI;
    }

    public Style getStyle() {
        if (this.style == null) {
            SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext != null && msgContext.getOperationMetaData() != null) {
                this.style = msgContext.getOperationMetaData().getStyle();
            }
            log.trace((Object)("Using style: " + this.style));
        }
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public SOAPMessage createMessage() throws SOAPException {
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
        new SOAPEnvelopeImpl(soapPart, this.envelopeURI);
        return soapMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream ins) throws IOException, SOAPException {
        try {
            ThreadLocalAssociation.localDomExpansion().set(Boolean.FALSE);
            SOAPMessage sOAPMessage = this.createMessageInternal(mimeHeaders, ins, false);
            return sOAPMessage;
        }
        finally {
            ThreadLocalAssociation.localDomExpansion().set(Boolean.TRUE);
        }
    }

    public SOAPMessage createMessageInternal(MimeHeaders mimeHeaders, InputStream ins, boolean ingnoreParseException) throws IOException, SOAPException {
        if (mimeHeaders == null) {
            mimeHeaders = new MimeHeaders();
        } else if (log.isTraceEnabled()) {
            Iterator itMimeHeaders = mimeHeaders.getAllHeaders();
            while (itMimeHeaders.hasNext()) {
                MimeHeader mh = (MimeHeader)itMimeHeaders.next();
                log.trace((Object)mh);
            }
        }
        ContentType contentType = MessageFactoryImpl.getContentType(mimeHeaders);
        log.debug((Object)("createMessage: [contentType=" + contentType + "]"));
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            IOUtils.copyStream(baos, ins);
            byte[] bytes = baos.toByteArray();
            log.trace((Object)("createMessage\n" + new String(bytes)));
            ins = new ByteArrayInputStream(bytes);
        }
        Collection<AttachmentPart> attachments = null;
        if (this.isMultipartRelatedContent(contentType)) {
            MultipartRelatedDecoder decoder;
            try {
                decoder = new MultipartRelatedDecoder(contentType);
                decoder.decodeMultipartRelatedMessage(ins);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SOAPException("Cannot decode multipart related message", ex);
            }
            ins = decoder.getRootPart().getDataHandler().getInputStream();
            attachments = decoder.getRelatedParts();
        } else if (!this.isSoapContent(contentType)) {
            throw new SOAPException("Unsupported content type: " + contentType);
        }
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        if (mimeHeaders != null) {
            soapMessage.setMimeHeaders(mimeHeaders);
        }
        if (attachments != null) {
            soapMessage.setAttachments(attachments);
        }
        SAAJEnvelopeBuilderFactory builderFactory = SAAJEnvelopeBuilderFactory.newInstance();
        SAAJEnvelopeBuilder envelopeBuilder = builderFactory.createSAAJEnvelopeBuilder();
        envelopeBuilder.setIgnoreParseException(ingnoreParseException);
        envelopeBuilder.setStyle(this.getStyle());
        envelopeBuilder.setSOAPMessage(soapMessage);
        envelopeBuilder.build(ins);
        return soapMessage;
    }

    private static ContentType getContentType(MimeHeaders headers) throws SOAPException {
        ContentType contentType = null;
        try {
            String[] type = headers.getHeader("Content-Type");
            contentType = type != null ? new ContentType(type[0]) : new ContentType("text/xml");
            return contentType;
        }
        catch (ParseException e) {
            throw new SOAPException("Could not parse content type:" + (Object)((Object)e));
        }
    }

    private boolean isSoapContent(ContentType type) {
        String baseType = type.getBaseType();
        return "text/xml".equals(baseType) || "application/soap+xml".equals(baseType);
    }

    private boolean isMultipartRelatedContent(ContentType type) {
        String baseType = type.getBaseType();
        return "multipart/related".equals(baseType);
    }
}

