/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPContentElement;
import org.jboss.ws.soap.SOAPElementImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPBodyElementRpc
extends SOAPElementImpl
implements SOAPBodyElement {
    public SOAPBodyElementRpc(Name name) {
        super(name);
    }

    public SOAPBodyElementRpc(SOAPElementImpl element) {
        super(element);
    }

    public String write(Writer writer, boolean pretty) {
        try {
            writer.write(60);
            String prefix = this.getPrefix() != null ? this.getPrefix() : "";
            String fqn = prefix.length() > 0 ? prefix + ":" + this.getLocalName() : this.getLocalName();
            writer.write(fqn);
            Iterator it = this.getNamespacePrefixes();
            while (it.hasNext()) {
                String nsPrefix = (String)it.next();
                writer.write(" xmlns:" + nsPrefix + "='" + this.getNamespaceURI(nsPrefix) + "'");
            }
            Iterator attNames = this.getAllAttributes();
            while (attNames.hasNext()) {
                NameImpl name = (NameImpl)attNames.next();
                String attPrefix = name.getPrefix() != null ? name.getPrefix() : "";
                String attFqn = attPrefix.length() > 0 ? attPrefix + ":" + name.getLocalName() : name.getLocalName();
                writer.write(" " + attFqn);
                writer.write("='" + this.getAttributeValue(name) + "'");
            }
            writer.write(62);
            Iterator children = this.getChildElements();
            while (children.hasNext()) {
                Object child = children.next();
                if (child instanceof SOAPContentElement) continue;
                DOMWriter domWriter = new DOMWriter(writer);
                domWriter.setPrettyprint(pretty);
                domWriter.print((Node)((Element)child));
            }
            if (pretty) {
                writer.write("\n");
            }
            return "</" + fqn + ">";
        }
        catch (IOException e) {
            throw new JAXRPCException(e);
        }
    }
}

