/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.Constants;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPBodyImpl;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPHeaderImpl;
import org.jboss.ws.soap.SOAPPartImpl;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Document;

public class SOAPEnvelopeImpl
extends SOAPElementImpl
implements SOAPEnvelope {
    private SOAPPartImpl soapPart;
    private boolean domExpansionEnabled = false;
    private NamespaceRegistry namespaceRegistry = new NamespaceRegistry();

    public SOAPEnvelopeImpl(SOAPPartImpl soapPart, SOAPElementImpl element) throws SOAPException {
        super(element);
        this.soapPart = soapPart;
        soapPart.setEnvelope(this);
        String prefix = this.getPrefix();
        String namespaceURI = this.getNamespaceURI();
        this.assertEnvelopeNamespace(namespaceURI);
        this.namespaceRegistry.registerURI(namespaceURI, prefix);
        this.addNamespaceDeclaration(prefix, namespaceURI);
        this.addHeader();
        this.addBody();
    }

    SOAPEnvelopeImpl(SOAPPartImpl soapPart, String namespace) throws SOAPException {
        super("Envelope", "env", namespace);
        this.soapPart = soapPart;
        soapPart.setEnvelope(this);
        this.assertEnvelopeNamespace(namespace);
        this.namespaceRegistry.registerURI(this.getNamespaceURI(), this.getPrefix());
        this.addNamespaceDeclaration(this.getPrefix(), namespace);
        this.addHeader();
        this.addBody();
    }

    private void assertEnvelopeNamespace(String namespaceURI) {
        if (!"http://www.w3.org/2003/05/soap-envelope".equals(namespaceURI) && !"http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) {
            QName faultCode = Constants.SOAP11_FAULT_CODE_VERSION_MISMATCH;
            String faultString = "Invalid SOAP envelope namespace: " + namespaceURI;
            throw new SOAPFaultException(faultCode, faultString, null, null);
        }
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapPart.getSOAPMessage();
    }

    public SOAPBody addBody() throws SOAPException {
        SOAPBody body = this.getBody();
        if (body != null) {
            throw new SOAPException("SOAPEnvelope already has a body element");
        }
        body = new SOAPBodyImpl(this.getPrefix(), this.getNamespaceURI());
        this.addChildElement(body);
        return body;
    }

    public SOAPHeader addHeader() throws SOAPException {
        SOAPHeader header = this.getHeader();
        if (header != null) {
            throw new SOAPException("SOAPEnvelope already has a header element");
        }
        header = new SOAPHeaderImpl(this.getPrefix(), this.getNamespaceURI());
        return (SOAPHeader)this.addChildElement(header);
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        if (!(child instanceof SOAPHeader) && !(child instanceof SOAPBody)) {
            throw new IllegalArgumentException("SOAPHeader or SOAPBody expected");
        }
        return super.addChildElement(child);
    }

    public Name createName(String localName) throws SOAPException {
        return new NameImpl(localName);
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new NameImpl(localName, prefix, uri);
    }

    public SOAPBody getBody() throws SOAPException {
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!node.getLocalName().equals("Body")) continue;
            return (SOAPBody)node;
        }
        return null;
    }

    public SOAPHeader getHeader() throws SOAPException {
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!node.getLocalName().equals("Header")) continue;
            return (SOAPHeader)node;
        }
        return null;
    }

    public SOAPElement addTextNode(String value) throws SOAPException {
        throw new SOAPException("Cannot add Text node to SOAPEnvelope");
    }

    public Document getOwnerDocument() {
        return this.soapPart;
    }

    public String write(Writer writer, boolean pretty) {
        try {
            writer.write("<");
            String envPrefix = this.getPrefix();
            writer.write(envPrefix + ":Envelope xmlns:" + this.getPrefix() + "='" + this.getNamespaceURI() + "'");
            Iterator it = this.getNamespacePrefixes();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                if (prefix.equals(envPrefix)) continue;
                writer.write(" xmlns:" + prefix + "='" + this.getNamespaceURI(prefix) + "'");
            }
            writer.write(62);
            if (pretty) {
                writer.write("\n");
            }
            return "</" + this.getPrefix() + ":Envelope>";
        }
        catch (IOException e) {
            throw new JAXRPCException(e);
        }
    }
}

