/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.soap.DetailEntryImpl;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPBodyElementDoc;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPFactoryImpl;
import org.jboss.xb.QNameBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPFaultImpl
extends SOAPBodyElementDoc
implements SOAPFault {
    private static Logger log = Logger.getLogger(SOAPFaultImpl.class);
    private SOAPElement faultcode;
    private SOAPElement faultstring;
    private SOAPElement faultactor;
    private Locale faultStringLocale;

    public SOAPFaultImpl(String namespaceURI) throws SOAPException {
        super(new NameImpl("Fault", "env", namespaceURI));
    }

    public SOAPFaultImpl(SOAPElementImpl element) {
        super(element);
    }

    public Detail addDetail() throws SOAPException {
        Detail detail = this.getDetail();
        if (detail != null) {
            throw new SOAPException("SOAPFault already contains a detail node");
        }
        SOAPFactoryImpl factory = new SOAPFactoryImpl();
        detail = (Detail)this.addChildElement(factory.createDetail());
        return detail;
    }

    public Detail getDetail() {
        Detail detail = null;
        Iterator it = this.getChildElements(new NameImpl("detail"));
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Detail) {
                detail = (Detail)obj;
                continue;
            }
            if (!(obj instanceof SOAPElementImpl)) continue;
            try {
                SOAPElementImpl soapEl = (SOAPElementImpl)obj;
                SOAPFactoryImpl factory = new SOAPFactoryImpl();
                detail = (Detail)this.addChildElement(factory.createDetail());
                Iterator childIt = DOMUtils.getChildElements((Node)soapEl);
                while (childIt.hasNext()) {
                    Element domElement = (Element)childIt.next();
                    DetailEntryImpl detailEntry = new DetailEntryImpl(factory.createElement(domElement, true));
                    detail.addChildElement(detailEntry);
                }
            }
            catch (SOAPException e) {
                throw new WSException("Unable to create fault detail: " + e.getMessage());
            }
        }
        return detail;
    }

    public String getFaultActor() {
        if (this.faultactor == null) {
            Element domFaultCode = DOMUtils.getFirstChildElement((Node)this, (QName)new QName("faultactor"));
            if (domFaultCode instanceof SOAPElement) {
                this.faultactor = (SOAPElement)domFaultCode;
            } else {
                return null;
            }
        }
        return this.faultactor.getValue();
    }

    public String getFaultCode() {
        if (this.faultcode == null) {
            Element domFaultCode = DOMUtils.getFirstChildElement((Node)this, (QName)new QName("faultcode"));
            if (domFaultCode instanceof SOAPElement) {
                this.faultcode = (SOAPElement)domFaultCode;
            } else {
                return null;
            }
        }
        String value = this.faultcode.getValue();
        return value;
    }

    public Name getFaultCodeAsName() {
        QName qname = QNameBuilder.buildQName((Element)this, (String)this.getFaultCode());
        return new NameImpl(qname);
    }

    public String getFaultString() {
        if (this.faultstring == null) {
            Element domFaultCode = DOMUtils.getFirstChildElement((Node)this, (QName)new QName("faultstring"));
            if (domFaultCode instanceof SOAPElement) {
                this.faultstring = (SOAPElement)domFaultCode;
            } else {
                return null;
            }
        }
        String value = this.faultstring.getValue();
        return value;
    }

    public Locale getFaultStringLocale() {
        return this.faultStringLocale;
    }

    public void setFaultActor(String faultActor) throws SOAPException {
        if (this.getFaultActor() == null) {
            SOAPFactoryImpl factory = new SOAPFactoryImpl();
            this.faultactor = factory.createElement("faultactor");
            this.addChildElement(this.faultactor);
        }
        this.faultactor.setValue(faultActor);
    }

    public void setFaultCode(String faultCode) throws SOAPException {
        if (faultCode == null || faultCode.indexOf(":") < 1) {
            throw new IllegalArgumentException("Invalid faultCode: " + faultCode);
        }
        QName qname = QNameBuilder.buildQName((Element)this, (String)faultCode);
        this.setFaultCode(new NameImpl(qname));
    }

    public void setFaultCode(Name faultName) throws SOAPException {
        String prevNS;
        String nsURI = faultName.getURI();
        String prefix = faultName.getPrefix();
        String localName = faultName.getLocalName();
        if ("".equals(nsURI)) {
            log.warn((Object)("Empty namespace URI with fault code '" + faultName + "', assuming: " + "http://schemas.xmlsoap.org/soap/envelope/"));
            nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if ("".equals(prefix) && this.getNamespaceURI().equals(nsURI)) {
            prefix = this.getPrefix();
        }
        if (!nsURI.equals(prevNS = this.getNamespaceURI(prefix))) {
            this.addNamespaceDeclaration(prefix, nsURI);
        }
        String faultCode = prefix + ":" + localName;
        if (this.getFaultCode() == null) {
            SOAPFactoryImpl factory = new SOAPFactoryImpl();
            this.faultcode = factory.createElement("faultcode");
            this.addChildElement(this.faultcode);
        }
        this.faultcode.setValue(faultCode);
    }

    public void setFaultString(String faultString) throws SOAPException {
        if (this.getFaultString() == null) {
            SOAPFactoryImpl factory = new SOAPFactoryImpl();
            this.faultstring = factory.createElement("faultstring");
            this.addChildElement(this.faultstring);
        }
        this.faultstring.setValue(faultString);
    }

    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        this.setFaultString(faultString);
        this.faultStringLocale = locale;
    }

    public String write(Writer writer, boolean pretty) {
        try {
            DOMWriter dw = new DOMWriter(writer);
            dw.setPrettyprint(pretty);
            dw.print((Node)this);
        }
        catch (Exception e) {
            throw new JAXRPCException(e);
        }
        return null;
    }
}

