/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.WSException;
import org.jboss.ws.handler.MessageContextImpl;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.xb.binding.NamespaceRegistry;

public class SOAPMessageContextImpl
extends MessageContextImpl
implements SOAPMessageContext {
    private SOAPMessage soapMessage;
    private EndpointMetaData epMetaData;
    private OperationMetaData opMetaData;
    private SerializationContextImpl serContext;

    public SOAPMessage getMessage() {
        return this.soapMessage;
    }

    public void setMessage(SOAPMessage message) {
        this.soapMessage = message;
    }

    public String[] getRoles() {
        return new String[0];
    }

    public EndpointMetaData getEndpointMetaData() {
        if (this.epMetaData == null && this.opMetaData != null) {
            this.epMetaData = this.opMetaData.getEndpointMetaData();
        }
        return this.epMetaData;
    }

    public void setEndpointMetaData(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public void setOperationMetaData(OperationMetaData opMetaData) {
        this.opMetaData = opMetaData;
    }

    public SerializationContextImpl getSerializationContext() {
        if (this.serContext == null) {
            ServiceMetaData serviceMetaData = this.getEndpointMetaData().getServiceMetaData();
            this.serContext = new SerializationContextImpl();
            this.serContext.setTypeMapping(serviceMetaData.getTypeMapping());
            this.serContext.setJavaWsdlMapping(serviceMetaData.getJavaWsdlMapping());
        }
        this.serContext.setNamespaceRegistry(this.getNamespaceRegistry());
        return this.serContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        if (this.soapMessage == null) {
            throw new WSException("Cannot obtain NamespaceRegistry, because there is no SOAPMessage associated with this context");
        }
        try {
            SOAPEnvelopeImpl soapEnv = (SOAPEnvelopeImpl)this.soapMessage.getSOAPPart().getEnvelope();
            NamespaceRegistry nsRegistry = soapEnv.getNamespaceRegistry();
            return nsRegistry;
        }
        catch (SOAPException e) {
            throw new WSException("Cannot get SOAPEnvelope: " + e);
        }
    }
}

