/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap.attachment;

import com.sun.mail.handlers.multipart_mixed;
import com.sun.mail.handlers.text_html;
import com.sun.mail.handlers.text_plain;
import java.awt.datatransfer.DataFlavor;
import java.util.HashSet;
import java.util.Iterator;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.MailcapCommandMap;
import org.jboss.ws.soap.attachment.ByteArrayContentHandler;
import org.jboss.ws.soap.attachment.ImageDataContentHandler;
import org.jboss.ws.soap.attachment.XmlDataContentHandler;

public class ContentHandlerRegistry {
    private static final String JAF_CONTENT_HANDLER = "x-java-content-handler";
    private static HashSet handlerRegistry = new HashSet();

    private static void addRegistryEntry(Class contentHandler) {
        handlerRegistry.add(contentHandler);
    }

    private static void registerContentHandler(Class contentHandler) {
        DataContentHandler handler;
        MailcapCommandMap mailcap;
        try {
            mailcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            handler = (DataContentHandler)contentHandler.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not register content handler:" + e.getMessage());
        }
        DataFlavor[] flavors = handler.getTransferDataFlavors();
        if (flavors == null) {
            return;
        }
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            String entry = flavor.getMimeType() + ";;" + JAF_CONTENT_HANDLER + "=" + contentHandler.getName();
            mailcap.addMailcap(entry);
        }
    }

    public static void register() {
        Iterator i = handlerRegistry.iterator();
        while (i.hasNext()) {
            ContentHandlerRegistry.registerContentHandler((Class)i.next());
        }
    }

    static {
        ContentHandlerRegistry.addRegistryEntry(XmlDataContentHandler.class);
        ContentHandlerRegistry.addRegistryEntry(ImageDataContentHandler.class);
        ContentHandlerRegistry.addRegistryEntry(ByteArrayContentHandler.class);
        ContentHandlerRegistry.addRegistryEntry(text_plain.class);
        ContentHandlerRegistry.addRegistryEntry(text_html.class);
        ContentHandlerRegistry.addRegistryEntry(multipart_mixed.class);
    }
}

