/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.metadata;

import java.rmi.Remote;
import java.util.List;
import java.util.Map;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.metadata.ReflectiveMetaDataBuilder;
import org.jboss.ws.tools.metadata.ToolsEndpointMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsUnifiedMetaDataBuilder {
    private static Logger log = Logger.getLogger(ToolsUnifiedMetaDataBuilder.class);
    private Class seiClass;
    private UnifiedMetaData um;
    private String targetNamespace = null;
    private String typeNamespace = null;
    private String serviceName = null;
    private Map<String, List<Configuration.OperationConfig>> operationMap = null;
    private Style style;
    private SOAPBinding.ParameterStyle parameterStyle;

    public ToolsUnifiedMetaDataBuilder(Class epClass, String targetNamespace, String typeNamespace, String serviceName, Style style, SOAPBinding.ParameterStyle parameterStyle, Map<String, List<Configuration.OperationConfig>> operationMap) {
        this.seiClass = epClass;
        this.targetNamespace = targetNamespace;
        this.typeNamespace = typeNamespace != null ? typeNamespace : targetNamespace;
        this.serviceName = serviceName;
        this.style = style;
        this.parameterStyle = parameterStyle;
        this.operationMap = operationMap;
        this.buildMetaData();
    }

    public UnifiedMetaData getUnifiedMetaData() {
        return this.um;
    }

    private void buildMetaData() {
        if (!Remote.class.isAssignableFrom(this.seiClass)) {
            throw new WSException("A service endpoint interface should extend Remote");
        }
        this.um = new UnifiedMetaData();
        String seiName = WSDLUtils.getInstance().getJustClassName(this.seiClass.getName());
        if (this.serviceName == null) {
            this.serviceName = seiName + "Service";
        }
        String portName = seiName + "Port";
        this.um.addService(this.getServiceMetaData(this.um, this.targetNamespace, this.serviceName, portName, this.seiClass));
        this.generateOperationMetaData(this.seiClass);
    }

    private void generateOperationMetaData(Class seiClass) {
        ServiceMetaData sm = this.um.getServices().get(0);
        ToolsEndpointMetaData em = (ToolsEndpointMetaData)sm.getEndpointByServiceEndpointInterface(seiClass.getName());
        if (em == null) {
            throw new WSException("EndpointMetadata is null");
        }
        ReflectiveMetaDataBuilder rmb = new ReflectiveMetaDataBuilder(em);
        rmb.setOperationMap(this.operationMap);
        em = rmb.generate();
    }

    private ServiceMetaData getServiceMetaData(UnifiedMetaData um, String targetNamespace, String serviceName, String portName, Class seiClass) {
        ServiceMetaData sm = new ServiceMetaData(um, new QName(targetNamespace, serviceName));
        ToolsEndpointMetaData tm = new ToolsEndpointMetaData(sm, new QName(targetNamespace, portName));
        tm.typeNamespace = this.typeNamespace;
        tm.setServiceEndpointInterfaceName(seiClass.getName());
        tm.setStyle(this.style);
        tm.setParameterStyle(this.parameterStyle);
        sm.addEndpoint(tm);
        return sm;
    }
}

