/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.activation.DataHandler;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;

public final class IOUtils {
    private static Logger log = Logger.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static Writer getCharsetFileWriter(File file, String charset) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
    }

    public static void copyStream(OutputStream outs, InputStream ins) throws IOException {
        byte[] bytes = new byte[1024];
        int r = ins.read(bytes);
        while (r > 0) {
            outs.write(bytes, 0, r);
            r = ins.read(bytes);
        }
    }

    public static byte[] convertToBytes(DataHandler dh) {
        try {
            ByteArrayOutputStream buffOS = new ByteArrayOutputStream();
            dh.writeTo((OutputStream)buffOS);
            return buffOS.toByteArray();
        }
        catch (IOException e) {
            throw new WSException("Unable to convert DataHandler to byte[]: " + e.getMessage());
        }
    }
}

