/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import java.io.IOException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBossWSEntityResolver
extends JBossEntityResolver {
    private static final Logger log = Logger.getLogger(JBossWSEntityResolver.class);

    public JBossWSEntityResolver() {
        JBossWSEntityResolver.registerEntity((String)"urn:jboss:jaxrpc-config:2.0", (String)"schema/jaxrpc-config_2_0.xsd");
        JBossWSEntityResolver.registerEntity((String)"urn:jboss:jaxws-config:2.0", (String)"schema/jaxws-config_2_0.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://java.sun.com/xml/ns/javaee", (String)"schema/handler-chain.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://www.w3.org/2005/08/addressing", (String)"schema/ws-addr.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://schemas.xmlsoap.org/ws/2004/08/eventing", (String)"eventing.xsd");
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        log.debug((Object)("resolveEntity: [pub=" + publicId + ",sysid=" + systemId + "]"));
        InputSource inputSource = super.resolveEntity(publicId, systemId);
        return inputSource;
    }

    public URL resolveNamespaceURI(String nsURI) {
        ClassLoader loader;
        URL url = null;
        String resource = (String)JBossWSEntityResolver.getEntityMap().get(nsURI);
        if (resource != null && (url = (loader = Thread.currentThread().getContextClassLoader()).getResource(resource)) == null) {
            if (resource.endsWith(".dtd")) {
                resource = "dtd/" + resource;
            } else if (resource.endsWith(".xsd")) {
                resource = "schema/" + resource;
            }
            url = loader.getResource(resource);
        }
        return url;
    }
}

