/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.wsse.WSSecurityDispatcher;

public abstract class WSSecurityHandler
extends GenericHandler {
    protected static String FAULT_THROWN = "org.jboss.ws.wsse.faultThrown";
    private static Logger log = Logger.getLogger(WSSecurityHandler.class);

    public QName[] getHeaders() {
        return null;
    }

    protected boolean thrownByMe(MessageContext msgContext) {
        Boolean bool = (Boolean)msgContext.getProperty(FAULT_THROWN);
        return bool != null && bool != false;
    }

    protected boolean handleInboundSecurity(MessageContext msgContext) {
        Exception exception = null;
        try {
            if (this.getSecurityConfiguration(msgContext) != null) {
                WSSecurityDispatcher.handleInbound((SOAPMessageContextImpl)msgContext);
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        if (exception != null) {
            msgContext.setProperty(FAULT_THROWN, true);
            if (exception instanceof SOAPFaultException) {
                throw (SOAPFaultException)exception;
            }
            log.error((Object)"Cannot handle inbound ws-security", (Throwable)exception);
            return false;
        }
        return true;
    }

    protected boolean handleOutboundSecurity(MessageContext msgContext) {
        Exception exception = null;
        try {
            if (this.getSecurityConfiguration(msgContext) != null) {
                WSSecurityDispatcher.handleOutbound((SOAPMessageContextImpl)msgContext);
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        if (exception != null) {
            msgContext.setProperty(FAULT_THROWN, true);
            if (exception instanceof SOAPFaultException) {
                throw (SOAPFaultException)exception;
            }
            log.error((Object)"Cannot handle outbound ws-security", (Throwable)exception);
            return false;
        }
        return true;
    }

    private WSSecurityConfiguration getSecurityConfiguration(MessageContext msgContext) {
        EndpointMetaData epMetaData = ((SOAPMessageContextImpl)msgContext).getEndpointMetaData();
        WSSecurityConfiguration securityConfiguration = epMetaData.getServiceMetaData().getSecurityConfiguration();
        if (securityConfiguration == null) {
            log.warn((Object)"Cannot obtain security configuration");
        }
        return securityConfiguration;
    }
}

