/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.xop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.jboss.xb.binding.JBossXBRuntimeException;

public class SimpleDataSource
implements DataSource {
    public final byte[] bytes;
    public final String contentType;

    public SimpleDataSource(Object o, String contentType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
        }
        catch (IOException e) {
            throw new JBossXBRuntimeException("XOP failed to serialize object " + o + ": " + e.getMessage());
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
        this.bytes = baos.toByteArray();
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public String getName() {
        throw new UnsupportedOperationException("getName is not implemented.");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("getOutputStream is not implemented.");
    }
}

