/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.xop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.soap.attachment.ContentHandlerRegistry;
import org.jboss.ws.xop.XOPContext;
import org.jboss.xb.binding.sunday.xop.XOPObject;
import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;

public class XOPUnmarshallerImpl
implements XOPUnmarshaller {
    private static final Logger log = Logger.getLogger(XOPUnmarshallerImpl.class);

    public boolean isXOPPackage() {
        return XOPContext.isXOPPackage();
    }

    public XOPObject getAttachmentAsDataHandler(String cid) {
        try {
            AttachmentPart part = XOPContext.getAttachmentByCID(cid);
            XOPObject xopObject = new XOPObject((Object)part.getDataHandler());
            xopObject.setContentType(part.getDataHandler().getContentType());
            return xopObject;
        }
        catch (SOAPException ex) {
            throw new WSException(ex);
        }
    }

    public byte[] getAttachmentAsByteArray(String cid) {
        try {
            AttachmentPart part = XOPContext.getAttachmentByCID(cid);
            DataHandler dh = part.getDataHandler();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            dh.writeTo((OutputStream)bout);
            return bout.toByteArray();
        }
        catch (SOAPException ex) {
            throw new WSException(ex);
        }
        catch (IOException e) {
            throw new WSException(e);
        }
    }

    static {
        ContentHandlerRegistry.register();
    }
}

