/*
 * Decompiled with CFR 0.152.
 */
package servletunit.struts;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionServlet;
import servletunit.HttpServletRequestSimulator;
import servletunit.HttpServletResponseSimulator;
import servletunit.ServletConfigSimulator;
import servletunit.ServletContextSimulator;
import servletunit.struts.Common;
import servletunit.struts.ExceptionDuringTestError;

public class MockStrutsTestCase
extends TestCase {
    protected ActionServlet actionServlet;
    protected HttpServletRequestSimulator request;
    protected HttpServletResponseSimulator response;
    protected HttpServletRequestWrapper requestWrapper;
    protected HttpServletResponseWrapper responseWrapper;
    protected ServletContextSimulator context;
    protected ServletConfigSimulator config;
    protected String actionPath;
    protected boolean isInitialized = false;
    protected boolean actionServletIsInitialized = false;
    protected boolean requestPathSet = false;
    protected String[] registrations = new String[]{"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "/org/apache/struts/resources/web-app_2_2.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/org/apache/struts/resources/web-app_2_3.dtd"};
    protected static Log logger = LogFactory.getLog((Class)(class$servletunit$struts$MockStrutsTestCase == null ? (class$servletunit$struts$MockStrutsTestCase = MockStrutsTestCase.class$("servletunit.struts.MockStrutsTestCase")) : class$servletunit$struts$MockStrutsTestCase));
    static /* synthetic */ Class class$servletunit$struts$MockStrutsTestCase;

    public MockStrutsTestCase() {
    }

    public MockStrutsTestCase(String testName) {
        super(testName);
    }

    private void init() {
        if (!this.isInitialized) {
            throw new AssertionFailedError("You are overriding the setUp() method without calling super.setUp().  You must call the superclass setUp() method in your TestCase subclass to ensure proper initialization.");
        }
    }

    protected void setUp() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        if (this.actionServlet == null) {
            this.actionServlet = new ActionServlet();
        }
        this.config = new ServletConfigSimulator();
        this.request = new HttpServletRequestSimulator(this.config.getServletContext());
        this.response = new HttpServletResponseSimulator();
        this.context = (ServletContextSimulator)this.config.getServletContext();
        this.requestWrapper = null;
        this.responseWrapper = null;
        this.isInitialized = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    protected void tearDown() throws Exception {
        ActionServlet servlet = this.getActionServlet();
        servlet.destroy();
        this.setActionServlet(servlet);
    }

    public HttpServletRequest getRequest() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.request;
    }

    public HttpServletRequestWrapper getRequestWrapper() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (this.requestWrapper == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting");
            }
            return new HttpServletRequestWrapper((HttpServletRequest)this.request);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("wrapper class is '" + this.requestWrapper.getClass() + "'"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.requestWrapper;
    }

    public void setRequestWrapper(HttpServletRequestWrapper wrapper) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - wrapper = " + wrapper));
        }
        this.init();
        if (wrapper == null) {
            throw new IllegalArgumentException("wrapper class cannot be null!");
        }
        if (wrapper.getRequest() == null) {
            wrapper.setRequest((ServletRequest)this.request);
        }
        this.requestWrapper = wrapper;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void clearRequestParameters() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering");
        }
        this.request.getParameterMap().clear();
        this.response.removeHeader("Location");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    public HttpServletResponse getResponse() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.response;
    }

    public HttpServletResponseWrapper getResponseWrapper() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (this.responseWrapper == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting");
            }
            return new HttpServletResponseWrapper((HttpServletResponse)this.response);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("wrapper class is '" + this.responseWrapper.getClass() + "'"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.responseWrapper;
    }

    public void setResponseWrapper(HttpServletResponseWrapper wrapper) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - wrapper = " + wrapper));
        }
        this.init();
        if (wrapper == null) {
            throw new IllegalArgumentException("wrapper class cannot be null!");
        }
        if (wrapper.getResponse() == null) {
            wrapper.setResponse((ServletResponse)this.response);
        }
        this.responseWrapper = wrapper;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public HttpServletRequestSimulator getMockRequest() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering");
        }
        this.init();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
        return this.request;
    }

    public HttpServletResponseSimulator getMockResponse() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering");
        }
        this.init();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
        return this.response;
    }

    public HttpSession getSession() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.request.getSession(true);
    }

    public ActionServlet getActionServlet() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        try {
            if (!this.actionServletIsInitialized) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"intializing actionServlet");
                }
                this.actionServlet.init((ServletConfig)this.config);
                this.actionServletIsInitialized = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing action servlet", (Throwable)e);
            if (e.getMessage().equals("java.lang.NullPointerException")) {
                String message = "Error initializing action servlet: Unable to find /WEB-INF/web.xml.  TestCase is running from " + System.getProperty("user.dir") + " directory.  " + "Context directory ";
                message = this.context.getContextDirectory() == null ? message + "has not been set.  Try calling setContextDirectory() with a relative or absolute path" : message + "is " + this.context.getContextDirectory().getAbsolutePath();
                message = message + ".  /WEB-INF/web.xml must be found under the context directory, " + "the directory the test case is running from, or in the classpath.";
                MockStrutsTestCase.fail((String)message);
            }
            throw new AssertionFailedError(e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.actionServlet;
    }

    public void setActionServlet(ActionServlet servlet) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - servlet = " + servlet));
        }
        this.init();
        if (servlet == null) {
            throw new AssertionFailedError("Cannot set ActionServlet to null");
        }
        this.actionServlet = servlet;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        this.actionServletIsInitialized = false;
    }

    public void actionPerform() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        if (!this.requestPathSet) {
            throw new IllegalStateException("You must call setRequestPathInfo() prior to calling actionPerform().");
        }
        this.init();
        HttpServletRequestSimulator request = this.request;
        HttpServletResponseSimulator response = this.response;
        if (this.requestWrapper != null) {
            request = this.requestWrapper;
        }
        if (this.responseWrapper != null) {
            response = this.responseWrapper;
        }
        try {
            this.getActionServlet().doPost((HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (NullPointerException npe) {
            String message = "A NullPointerException was thrown.  This may indicate an error in your ActionForm, or it may indicate that the Struts ActionServlet was unable to find struts config file.  TestCase is running from " + System.getProperty("user.dir") + " directory.  " + "Context directory ";
            message = this.context.getContextDirectory() == null ? message + "has not been set.  Try calling setContextDirectory() with a relative or absolute path" : message + "is " + this.context.getContextDirectory().getAbsolutePath();
            message = message + ".  struts config file must be found under the context directory, " + "the directory the test case is running from, or in the classpath.";
            throw new ExceptionDuringTestError(message, npe);
        }
        catch (Exception e) {
            throw new ExceptionDuringTestError("An uncaught exception was thrown during actionExecute()", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void addRequestParameter(String parameterName, String parameterValue) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - parameterName = " + parameterName + ", parameterValue = " + parameterValue));
        }
        this.init();
        this.request.addParameter(parameterName, parameterValue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void addRequestParameter(String parameterName, String[] parameterValues) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - parameterName = " + parameterName + ", parameteValue = " + parameterValues));
        }
        this.init();
        this.request.addParameter(parameterName, parameterValues);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setRequestPathInfo(String pathInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - pathInfo = " + pathInfo));
        }
        this.init();
        this.setRequestPathInfo("", pathInfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setRequestPathInfo(String moduleName, String pathInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - moduleName = " + moduleName + ", pathInfo = " + pathInfo));
        }
        this.init();
        this.actionPath = Common.stripActionPath(pathInfo);
        if (moduleName != null) {
            if (!moduleName.equals("")) {
                if (!moduleName.startsWith("/")) {
                    moduleName = "/" + moduleName;
                }
                if (!moduleName.endsWith("/")) {
                    moduleName = moduleName + "/";
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setting request attribute - name = javax.servlet.include.servlet_path, value = " + moduleName));
            }
            this.request.setAttribute("javax.servlet.include.servlet_path", moduleName);
        }
        this.request.setPathInfo(this.actionPath);
        this.requestPathSet = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setInitParameter(String key, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - key = " + key + ", value = " + value));
        }
        this.init();
        this.config.setInitParameter(key, value);
        this.actionServletIsInitialized = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setContextDirectory(File contextDirectory) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - contextDirectory = " + contextDirectory));
        }
        this.init();
        this.context.setContextDirectory(contextDirectory);
        this.actionServletIsInitialized = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setConfigFile(String pathname) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - pathName = " + pathname));
        }
        this.init();
        this.setConfigFile(null, pathname);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setConfigFile(String moduleName, String pathname) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - moduleName = " + moduleName + ", pathname =" + pathname));
        }
        this.init();
        if (moduleName == null) {
            this.config.setInitParameter("config", pathname);
        } else {
            this.config.setInitParameter("config/" + moduleName, pathname);
        }
        this.actionServletIsInitialized = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setServletConfigFile(String pathname) {
        URL url;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - pathname = " + pathname));
        }
        this.init();
        Digester digester = new Digester();
        digester.push((Object)this.config);
        digester.setValidating(true);
        digester.addCallMethod("web-app/servlet/init-param", "setInitParameter", 2);
        digester.addCallParam("web-app/servlet/init-param/param-name", 0);
        digester.addCallParam("web-app/servlet/init-param/param-value", 1);
        try {
            for (int i = 0; i < this.registrations.length; i += 2) {
                url = this.context.getResource(this.registrations[i + 1]);
                if (url == null) continue;
                digester.register(this.registrations[i], url.toString());
            }
            InputStream input = this.context.getResourceAsStream(pathname);
            if (input == null) {
                throw new AssertionFailedError("Invalid pathname: " + pathname);
            }
            digester.parse(input);
            input.close();
        }
        catch (Exception e) {
            throw new AssertionFailedError("Received an exception while loading web.xml - " + e.getClass() + " : " + e.getMessage());
        }
        digester = new Digester();
        digester.setValidating(true);
        digester.push((Object)this.context);
        digester.addCallMethod("web-app/context-param", "setInitParameter", 2);
        digester.addCallParam("web-app/context-param/param-name", 0);
        digester.addCallParam("web-app/context-param/param-value", 1);
        try {
            for (int i = 0; i < this.registrations.length; i += 2) {
                url = this.context.getResource(this.registrations[i + 1]);
                if (url == null) continue;
                digester.register(this.registrations[i], url.toString());
            }
            InputStream input = this.context.getResourceAsStream(pathname);
            if (input == null) {
                throw new AssertionFailedError("Invalid pathname: " + pathname);
            }
            digester.parse(input);
            input.close();
        }
        catch (Exception e) {
            throw new AssertionFailedError("Received an exception while loading web.xml - " + e.getClass() + " : " + e.getMessage());
        }
        this.actionServletIsInitialized = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    protected String getActualForward() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        if (this.response.containsHeader("Location")) {
            return Common.stripJSessionID(this.response.getHeader("Location"));
        }
        try {
            String strippedForward = this.request.getContextPath() + Common.stripJSessionID(((ServletContextSimulator)this.config.getServletContext()).getRequestDispatcherSimulator().getForward());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("stripped forward and added context path - " + strippedForward));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting");
            }
            return strippedForward;
        }
        catch (NullPointerException npe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"caught NullPointerException - returning null", (Throwable)npe);
            }
            return null;
        }
    }

    public void verifyForward(String forwardName) throws AssertionFailedError {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - forwardName = " + forwardName));
        }
        this.init();
        Common.verifyForwardPath(this.actionPath, forwardName, this.getActualForward(), false, this.request, this.config.getServletContext(), this.config);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyForwardPath(String forwardPath) throws AssertionFailedError {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - forwardPath = " + forwardPath));
        }
        this.init();
        String actualForward = this.getActualForward();
        if (actualForward == null && forwardPath == null) {
            return;
        }
        forwardPath = this.request.getContextPath() + forwardPath;
        if (actualForward == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"actualForward is null - this usually means it is not mapped properly.");
            }
            throw new AssertionFailedError("Was expecting '" + forwardPath + "' but it appears the Action has tried to return an ActionForward that is not mapped correctly.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("expected forward = '" + forwardPath + "' - actual forward = '" + actualForward + "'"));
        }
        if (!actualForward.equals(forwardPath)) {
            throw new AssertionFailedError("was expecting '" + forwardPath + "' but received '" + actualForward + "'");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyInputForward() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        Common.verifyForwardPath(this.actionPath, null, this.getActualForward(), true, this.request, this.config.getServletContext(), this.config);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyTilesForward(String forwardName, String definitionName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - forwardName=" + forwardName + ", definitionName=" + definitionName));
        }
        this.init();
        Common.verifyTilesForward(this.actionPath, forwardName, definitionName, false, this.request, this.config.getServletContext(), this.config);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    public void verifyInputTilesForward(String definitionName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - definitionName=" + definitionName));
        }
        this.init();
        Common.verifyTilesForward(this.actionPath, null, definitionName, true, this.request, this.config.getServletContext(), this.config);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    public void verifyActionErrors(String[] errorNames) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("errorNames = " + errorNames));
        }
        this.init();
        Common.verifyActionMessages(this.request, errorNames, "org.apache.struts.action.ERROR", "error");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyNoActionErrors() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        Common.verifyNoActionMessages(this.request, "org.apache.struts.action.ERROR", "error");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyActionMessages(String[] messageNames) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - messageNames = " + messageNames));
        }
        this.init();
        Common.verifyActionMessages(this.request, messageNames, "org.apache.struts.action.ACTION_MESSAGE", "action");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyNoActionMessages() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        Common.verifyNoActionMessages(this.request, "org.apache.struts.action.ACTION_MESSAGE", "action");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public ActionForm getActionForm() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return Common.getActionForm(this.actionPath, this.request, this.context);
    }

    public void setActionForm(ActionForm form) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - form = " + form));
        }
        this.init();
        this.getActionServlet();
        Common.setActionForm(form, this.request, this.actionPath, this.context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

