/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.beans.serviceHandlers;

import com.ttv.acs.stub.adi.ADI;
import com.ttv.acs.stub.adi.ADIParseUtil;
import com.ttv.acs.stub.adi.Asset;
import com.ttv.acs.stub.adi.WorkOrderRequest;
import com.ttv.acs.util.ADIUtil;
import com.ttv.acs.util.ApplicationProperties;
import com.ttv.acs.util.ChecksumUtil;
import com.ttv.acs.util.FileURIConverter;
import com.ttv.acs.util.VirtualFileSystemManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.vfs.FileSystemException;
import org.apache.log4j.Logger;

public class LocalContentStoreHandler {
    private static LocalContentStoreHandler instance = null;
    private final Logger log = Logger.getLogger(LocalContentStoreHandler.class);
    private static String DATE_FORMAT = "MM-dd-yyyy";
    private static String TIME_FORMAT = "HHmmssSSS";

    public static synchronized LocalContentStoreHandler getInstance() {
        if (instance == null) {
            instance = new LocalContentStoreHandler();
        }
        return instance;
    }

    public WorkOrderRequest provisionPackage(String packageName, String URL2) throws Exception {
        this.log.info((Object)("Received provision request for package : " + packageName + ", at URL: " + URL2));
        boolean provisionResult = true;
        ArrayList<String> errorMsgs = new ArrayList<String>();
        String adiXMLFileName = this.getAdiXMLFileName(URL2);
        ADI adi = null;
        try {
            adi = this.getMetadata(packageName, URL2, adiXMLFileName);
        }
        catch (Exception ex) {
            String errMsg = "Failed to retrieve/parse URL: " + URL2;
            this.log.error((Object)errMsg, (Throwable)ex);
            errorMsgs.add(errMsg);
            provisionResult = false;
        }
        String metadataFilePath = URL2;
        if (adi != null) {
            Iterator<Asset> it = adi.getAssets().iterator();
            while (it.hasNext()) {
                Asset asset = it.next();
                boolean acquireResourceResult = true;
                try {
                    this.provisionAsset(asset, adi, metadataFilePath, adiXMLFileName);
                }
                catch (Exception ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    errorMsgs.add(ex.getMessage());
                    provisionResult = false;
                    acquireResourceResult = false;
                    it.remove();
                }
                String destinationStr = asset.getPath();
                if (!ADIUtil.getCheckChecksumFlag() || !acquireResourceResult || this.validateCheckSum(destinationStr, asset.getCheckSum())) continue;
                provisionResult = false;
                errorMsgs.add("Checksum validation failed for content " + asset.getContent());
                it.remove();
            }
            metadataFilePath = adi.getContentStoreDirectoryAbsolutePath() + File.separator + adiXMLFileName;
        }
        return this.constructWorkorderRequest(metadataFilePath, provisionResult, errorMsgs, adi);
    }

    private synchronized ADI getMetadata(String packageName, String URL2, CharSequence adiXMLFileName) throws Exception {
        File xmlTempFile = File.createTempFile("ADI", ".XML");
        File dtdTempFile = File.createTempFile("ADI", ".DTD");
        URI sourceURI = new URI(URL2);
        URI destinationURI = xmlTempFile.toURI();
        this.acquireResource(sourceURI, destinationURI);
        sourceURI = new URI(URL2.replace(adiXMLFileName, "ADI.DTD"));
        destinationURI = dtdTempFile.toURI();
        this.acquireResource(sourceURI, destinationURI);
        ADI adi = ADIParseUtil.parseFile(xmlTempFile, dtdTempFile);
        File contentStoreDirectoryPath = new File(this.getContentStoreAbsolutePath() + File.separator + adi.getMetadata().getProviderId() + File.separator + new SimpleDateFormat(DATE_FORMAT).format(new Date()) + File.separator + new SimpleDateFormat(TIME_FORMAT).format(new Date()) + File.separator + adi.getMetadata().getAssetId());
        if (!this.getVFS().localStorageDirectoryIsReady(contentStoreDirectoryPath.getAbsolutePath())) {
            String errorString = "Failed to create content store path: " + contentStoreDirectoryPath.getAbsolutePath();
            this.log.error((Object)errorString);
            throw new Exception(errorString);
        }
        adi.setContentStoreDirectoryAbsolutePath(contentStoreDirectoryPath.getAbsolutePath());
        sourceURI = xmlTempFile.toURI();
        destinationURI = new File(contentStoreDirectoryPath.getAbsolutePath() + File.separator + adiXMLFileName).toURI();
        this.acquireResource(sourceURI, destinationURI);
        sourceURI = dtdTempFile.toURI();
        destinationURI = new File(contentStoreDirectoryPath.getAbsolutePath() + File.separator + "ADI.DTD").toURI();
        this.acquireResource(sourceURI, destinationURI);
        if (!xmlTempFile.delete()) {
            xmlTempFile.deleteOnExit();
        }
        if (!dtdTempFile.delete()) {
            dtdTempFile.deleteOnExit();
        }
        return adi;
    }

    private String getAdiXMLFileName(String url) {
        return url.substring(url.length() - 7);
    }

    private WorkOrderRequest constructWorkorderRequest(String metadataFilePath, boolean provisionResult, List<String> errorMsgs, ADI adi) {
        return new WorkOrderRequest(metadataFilePath, provisionResult, errorMsgs, adi);
    }

    private boolean validateCheckSum(String contentFilePath, String checkSum) throws NoSuchAlgorithmException, IOException {
        String newChecksum = ChecksumUtil.getCheckSum(contentFilePath);
        boolean validateResult = checkSum.equals(newChecksum);
        if (!validateResult) {
            this.log.error((Object)("Checksum validation failed for file: " + contentFilePath));
            File contentFile = new File(contentFilePath);
            boolean deleteResult = contentFile.delete();
            if (!deleteResult) {
                this.log.error((Object)("Failed to delete content file " + contentFilePath));
            }
        }
        return validateResult;
    }

    public void acquireResource(URI source, URI destination) throws Exception {
        this.log.debug((Object)("Source resource: " + source.toString()));
        this.log.debug((Object)("Destination resource: " + destination.toString()));
        try {
            this.getVFS().copyURI(source, destination);
        }
        catch (FileSystemException fse) {
            String errorString = "Failed to copy sourcefile: " + source.toString() + " from remote system.";
            this.log.error((Object)errorString, (Throwable)fse);
            throw new Exception(errorString);
        }
        catch (IOException ioe) {
            String errorString = "Failed to copy sourcefile: " + source.toString() + " from remote system.";
            this.log.error((Object)errorString, (Throwable)ioe);
            throw new Exception(errorString);
        }
        catch (Exception e) {
            String errorString = "Failed to copy sourcefile: " + source.toString() + " from remote system.";
            this.log.error((Object)errorString, (Throwable)e);
            throw new Exception(errorString);
        }
    }

    public String getContentStoreAbsolutePath() {
        try {
            return ApplicationProperties.getInstance().getProperty("ACS_CONTENTSTORE", "/content");
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to get property ACS_NAME_SERVER_CORBALOC", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void initializeContentStore() {
        VirtualFileSystemManager vfs = this.getVFS();
        if (!vfs.localStorageDirectoryIsReady(this.getContentStoreAbsolutePath())) {
            this.log.error((Object)"Failed to create content store directory structure.", null);
        }
    }

    private VirtualFileSystemManager getVFS() {
        return new VirtualFileSystemManager();
    }

    private LocalContentStoreHandler() {
        this.initializeContentStore();
    }

    private void provisionAsset(Asset asset, ADI adi, String metadataFilePath, String metadataFileName) throws Exception {
        if (asset.hasFileURI()) {
            this.provisionAssetWithFileURI(asset, adi);
        } else {
            this.provisionAssetWithFTPURI(asset, adi, metadataFilePath, metadataFileName);
        }
    }

    private void provisionAssetWithFileURI(Asset asset, ADI adi) throws Exception {
        String content = asset.getContent();
        this.log.debug((Object)("Processing content :" + content));
        String contentPath = new FileURIConverter().convertURIToUnix(content);
        this.log.debug((Object)("Converted path :" + contentPath));
        if (contentPath == null) {
            asset.setPath(content);
            this.log.error((Object)("[Configuration Error] " + content + " fileURIConverter.properties cannot find converter entry for " + content));
            throw new Exception("Fail to convert URI:" + content);
        }
        asset.setPath(contentPath);
    }

    private void provisionAssetWithFTPURI(Asset asset, ADI adi, String metadataFilePath, String metadataFileName) throws Exception {
        String content = asset.getContent();
        this.log.debug((Object)("Processing content :" + content));
        URI sourceURI = null;
        URI destinationURI = null;
        if (asset.hasFTPURI()) {
            sourceURI = new URI(content);
            String path = sourceURI.getPath();
            String fileName = path.substring(path.lastIndexOf("/") + 1, path.length());
            destinationURI = new URI(adi.getContentStoreDirectoryAbsolutePath() + File.separator + fileName);
            asset.setPath(destinationURI.getPath());
        } else {
            destinationURI = new URI(adi.getContentStoreDirectoryAbsolutePath() + File.separator + content);
            asset.setPath(destinationURI.getPath());
            sourceURI = new URI(metadataFilePath.replace(metadataFileName, content));
        }
        try {
            this.acquireResource(sourceURI, destinationURI);
        }
        catch (Exception ex) {
            String errMsg = "Failed to acquire content: " + sourceURI.toString();
            throw new Exception(errMsg, ex);
        }
    }
}

