/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.jmx;

import com.ttv.acs.jmx.AssetFactoryService;
import com.ttv.acs.util.ADIUtil;
import com.twc.isa.AssetModule.AssetFactory;
import com.twc.isa.AssetModule.AssetFactory_impl;
import com.twc.isa.ServerModule.ServantBase_impl;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Management;
import org.jboss.ejb3.annotation.Service;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;

@Service(objectName="acs:service=AssetFactoryServiceMBean")
@Management(value=AssetFactoryService.class)
public class AssetFactoryServiceMBean
implements AssetFactoryService {
    private final Logger log = Logger.getLogger(AssetFactoryServiceMBean.class);
    private AssetFactoryControl assetFactoryControl = null;

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void start() throws Exception {
        this.log.info((java.lang.Object)"Starting Asset Factory.");
        this.startAssetFactoryService();
    }

    @Override
    public void stop() {
        this.log.info((java.lang.Object)"Stopping AssetFactory.");
        this.stopAssetFactoryService();
    }

    @Override
    public void startAssetFactoryService() {
        if (this.assetFactoryControl == null) {
            this.assetFactoryControl = new AssetFactoryControl();
            this.assetFactoryControl.start();
        } else {
            this.log.debug((java.lang.Object)"AssetFactory already running.");
        }
    }

    @Override
    public void stopAssetFactoryService() {
        if (this.assetFactoryControl != null) {
            this.assetFactoryControl.stopAssetFactory();
            this.log.debug((java.lang.Object)"AssetFactory signalled.");
        }
    }

    private class AssetFactoryControl
    extends Thread {
        private boolean stop = false;

        private AssetFactoryControl() {
        }

        public void stopAssetFactory() {
            this.stop = true;
            AssetFactoryServiceMBean.this.assetFactoryControl.interrupt();
        }

        @Override
        public void run() {
            while (!this.stop) {
                if (ADIUtil.getNameServerAddress() == null || ADIUtil.getNameServerAddress().length() == 0) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception ignore) {}
                    continue;
                }
                try {
                    this.startAssetFactory();
                }
                catch (InterruptedException ie) {
                    if (!this.stop) {
                        AssetFactoryServiceMBean.this.log.error((java.lang.Object)"AssetFactory caught InterruptedException. Restart scheduled.");
                    } else {
                        AssetFactoryServiceMBean.this.log.error((java.lang.Object)"AssetFactory Shutdown complete.");
                    }
                }
                catch (Exception e) {
                    AssetFactoryServiceMBean.this.log.error((java.lang.Object)"AssetFactory caught unexpected exception. Restart scheduled.", (Throwable)e);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            }
        }

        private void startAssetFactory() throws InterruptedException, Exception {
            ORB orb = ORB.init((String[])this.getOrbMainArgs(), (Properties)this.getProperties());
            POA rootPOA = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            POAManager manager = rootPOA.the_POAManager();
            manager.activate();
            AssetFactory_impl factoryImpl = new AssetFactory_impl(orb, "AssetFactory");
            AssetFactory factory = factoryImpl._this(orb);
            String[] serverPath = new String[]{"Factories", "AssetFactory"};
            factoryImpl.m_base.setFullPath(serverPath);
            ServantBase_impl.setFactoryObject(orb, serverPath, (Object)factory);
            manager.activate();
            AssetFactoryServiceMBean.this.log.info((java.lang.Object)("Bound AssetFactory to ior:" + factory.toString()));
            orb.run();
        }

        private String[] getOrbMainArgs() {
            String[] args = new String[]{"-ORBInitRef", "NameService=" + ADIUtil.getNameServerAddress()};
            return args;
        }

        private Properties getProperties() {
            Properties p = new Properties();
            p.put("OAPort", ADIUtil.getAssetFactoryPort());
            return p;
        }
    }
}

