/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.stub.adi;

import com.ttv.acs.stub.adi.ADI;
import com.ttv.acs.stub.adi.Asset;
import com.ttv.acs.stub.adi.Metadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ADIParseUtil {
    private static final Logger log = Logger.getLogger(ADIParseUtil.class);
    private static final XPath xpath = XPathFactory.newInstance().newXPath();

    public static ADI parseFile(File xmlFile, File dtdFile) throws Exception {
        log.debug((Object)("Begin parseFile(" + xmlFile));
        ADI adi = new ADI();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            builder.setEntityResolver(new ADIDTDEntityResolver(dtdFile));
            Document adiXML = builder.parse(xmlFile);
            String providerid = xpath.evaluate("/ADI/Metadata/AMS/@Provider_ID", adiXML);
            String assetID = xpath.evaluate("/ADI/Metadata/AMS/@Asset_ID", adiXML);
            Metadata meta = new Metadata(providerid, assetID);
            adi.setMetadata(meta);
            ArrayList<Asset> assets = new ArrayList<Asset>();
            adi.setAssets(assets);
            NodeList contents = XPathAPI.selectNodeList((Node)adiXML.getDocumentElement().getFirstChild(), (String)"//Content[string-length(@Value)>0]");
            if (contents != null) {
                for (int i = 0; i < contents.getLength(); ++i) {
                    Node assetNode = contents.item(i).getParentNode();
                    String checksum = xpath.evaluate("Metadata/App_Data[@Name='Content_CheckSum']/@Value", assetNode);
                    String content = xpath.evaluate("Content/@Value", assetNode);
                    Asset asset = new Asset(content, checksum);
                    assets.add(asset);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Fail to parse ADI.XML", (Throwable)e);
            throw e;
        }
        return adi;
    }

    public static ADI stubADI() {
        Asset movieAsset = new Asset("ModernGirlsGuidetoLife.mpg", "testchecksum");
        Asset adAsset = new Asset("neutrogena.mpg", "testchecksum");
        ArrayList<Asset> assets = new ArrayList<Asset>();
        assets.add(movieAsset);
        assets.add(adAsset);
        ADI stubADI = new ADI(assets, new Metadata("n2bb.com", "CBMV0001000000000001"));
        return stubADI;
    }

    public static class ADIDTDEntityResolver
    implements EntityResolver {
        File dtdFile;

        public ADIDTDEntityResolver(File dtdFile) {
            this.dtdFile = dtdFile;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            FileInputStream s = new FileInputStream(this.dtdFile);
            return new InputSource(s);
        }
    }
}

