/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.util;

import com.ttv.acs.util.ApplicationProperties;
import org.apache.log4j.Logger;

public class ADIUtil {
    private static final Logger log = Logger.getLogger(ADIUtil.class);

    public static String getNameServerAddress() {
        return ADIUtil.getProperty("ACS_NAME_SERVER_CORBALOC", "corbaloc::ACSServer:5000/StandardNS/NameServer-POA/_root");
    }

    public static String getContentStore() {
        return ADIUtil.getProperty("ACS_CONTENTSTORE", "/content");
    }

    public static boolean getCheckChecksumFlag() {
        String checksumFlag = ADIUtil.getProperty("VALIDATE_CHECKSUM", new Boolean("false").toString());
        try {
            return new Boolean(checksumFlag);
        }
        catch (Exception ex) {
            log.warn((Object)("[configuration error] VALIDATE_CHECKSUM adi.properties - property value:" + checksumFlag + " is not correct."));
            return false;
        }
    }

    public static String getPackageFactoryPort() {
        return ADIUtil.getProperty("PACKAGE_FACTORY_PORT", "42190");
    }

    public static String getAssetFactoryPort() {
        return ADIUtil.getProperty("ASSET_FACTORY_PORT", "42191");
    }

    public static String getProperty(String propertyName, String defaultValue) {
        try {
            return ApplicationProperties.getInstance().getProperty(propertyName, defaultValue);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get property " + propertyName), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

