/*
 * Decompiled with CFR 0.152.
 */
package com.twc.isa.ServerModule;

import com.twc.isa.ServerModule.AdministrativeState;
import com.twc.isa.ServerModule.NoGuiProvisioned;
import com.twc.isa.ServerModule.OperationalState;
import com.twc.isa.ServerModule.ServantBaseOperations;
import com.twc.isa.ServerModule.Unimplemented;
import com.twc.isa.ServerModule.UnspecifiedException;
import java.net.InetAddress;
import org.apache.log4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CosEventChannelAdmin.ProxyPushConsumer;
import org.omg.CosEventComm.Disconnected;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class ServantBase_
implements ServantBaseOperations {
    private final Logger log = Logger.getLogger(ServantBase_.class);
    private static POA m_poa = null;
    public String m_strName = null;
    public AdministrativeState m_AdministrativeState = null;
    public OperationalState m_OperationalState = null;
    public long m_lastModifiedTm = 0L;
    public long m_createdTm = 0L;
    public static ORB m_orb = null;
    private static ProxyPushConsumer m_PushConsumr = null;
    private String[] m_strFullPath;
    private static int m_iCnt = 0;
    private int m_iIdx = 0;

    public ServantBase_() {
        this.init();
        this.m_iIdx = ++m_iCnt;
        this.log.debug((java.lang.Object)("Servant Base Created : " + this.m_iIdx + " times"));
    }

    public ServantBase_(ORB orb, String strName) {
        this.init();
        this.m_iIdx = ++m_iCnt;
        this.log.debug((java.lang.Object)("Servant Base Created : " + this.m_iIdx + " times"));
        if (strName != null && !strName.trim().equals("")) {
            this.m_strName = strName;
        } else {
            try {
                this.m_strName = "Object_" + this.m_iIdx + "_on_" + InetAddress.getLocalHost().getHostAddress() + "_for_";
            }
            catch (Exception ex) {
                this.log.error(null, (Throwable)ex);
            }
        }
        if (m_orb == null) {
            m_orb = orb;
        }
        if (m_poa == null) {
            try {
                m_poa = POAHelper.narrow((Object)m_orb.resolve_initial_references("RootPOA"));
            }
            catch (Exception ex) {
                this.log.error(null, (Throwable)ex);
            }
        }
    }

    private void init() {
        this.m_AdministrativeState = AdministrativeState.as_Unprovisioned;
        this.m_OperationalState = OperationalState.os_Created;
        this.m_strName = "Un_Named_Object";
    }

    public static void destroy(Servant servant) {
        try {
            byte[] oid = m_poa.servant_to_id(servant);
            m_poa.deactivate_object(oid);
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException();
        }
        catch (ServantNotActive ex) {
            throw new RuntimeException();
        }
        catch (ObjectNotActive ex) {
            throw new RuntimeException();
        }
    }

    public String name() {
        return this.m_strName;
    }

    public void provisioningGui(StringHolder strHolder) throws NoGuiProvisioned {
        throw new NoGuiProvisioned();
    }

    public void destroy() {
        throw new RuntimeException("Not Implemetnted");
    }

    public void provision() {
        throw new RuntimeException("Not Implemetnted");
    }

    public void statusGui(StringHolder statusGui) throws NoGuiProvisioned {
        throw new NoGuiProvisioned();
    }

    public void setPushConsumer(ProxyPushConsumer pc) {
        m_PushConsumr = pc;
    }

    public ProxyPushConsumer getPushConsumer() {
        return m_PushConsumr;
    }

    public synchronized int send(String strEventName) {
        Any any = m_orb.create_any();
        any.insert_string(strEventName);
        try {
            m_PushConsumr.push(any);
            return 0;
        }
        catch (Disconnected ex) {
            this.log.info(null, (Throwable)ex);
        }
        catch (SystemException ex) {
            this.log.info(null, (Throwable)ex);
        }
        return 1;
    }

    public void setFullPath(String[] strFullPath) {
        this.m_strFullPath = strFullPath;
    }

    public String[] getFullPath() {
        return this.m_strFullPath;
    }

    public void setAdminState(AdministrativeState st) throws UnspecifiedException {
        this.m_AdministrativeState = st;
    }

    public AdministrativeState getAdminState() throws UnspecifiedException {
        return this.m_AdministrativeState;
    }

    public void getCreateTime(LongHolder longHolder) throws UnspecifiedException, Unimplemented {
        longHolder.value = this.m_createdTm;
    }

    public void getLastModifiedTime(LongHolder longHolder) throws UnspecifiedException, Unimplemented {
        longHolder.value = this.m_lastModifiedTm;
    }

    public OperationalState getOpState() throws UnspecifiedException {
        return this.m_OperationalState;
    }
}

