/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ORBInitInfoImpl
extends LocalObject
implements ORBInitInfo {
    private int slot_count = 0;
    private final ORB orb;
    private final Logger logger;
    private final Map named_server_interceptors;
    private final List anonymous_server_interceptors;
    private final Map named_client_interceptors;
    private final List anonymous_client_interceptors;
    private final Map named_ior_interceptors;
    private final List anonymous_ior_interceptors;
    private final Map policy_factories;
    private boolean valid = true;

    public ORBInitInfoImpl(ORB oRB) {
        this.orb = oRB;
        this.logger = oRB.getConfiguration().getNamedLogger("jacorb.orb");
        this.named_server_interceptors = new HashMap();
        this.named_client_interceptors = new HashMap();
        this.anonymous_server_interceptors = new ArrayList();
        this.anonymous_client_interceptors = new ArrayList();
        this.named_ior_interceptors = new HashMap();
        this.anonymous_ior_interceptors = new ArrayList();
        this.policy_factories = new HashMap();
    }

    public ORB getORB() {
        return this.orb;
    }

    public void setInvalid() {
        this.valid = false;
    }

    private List merge(List list, Map map) {
        ArrayList arrayList = new ArrayList(list);
        arrayList.addAll(map.values());
        return arrayList;
    }

    public List getClientInterceptors() {
        return this.merge(this.anonymous_client_interceptors, this.named_client_interceptors);
    }

    public List getServerInterceptors() {
        return this.merge(this.anonymous_server_interceptors, this.named_server_interceptors);
    }

    public List getIORInterceptors() {
        return this.merge(this.anonymous_ior_interceptors, this.named_ior_interceptors);
    }

    public Map getPolicyFactories() {
        return this.policy_factories;
    }

    public int getSlotCount() {
        return this.slot_count;
    }

    public void add_client_request_interceptor(ClientRequestInterceptor clientRequestInterceptor) throws DuplicateName {
        this.checkIsValid();
        this.checkInterceptorName(clientRequestInterceptor);
        if (clientRequestInterceptor.name().length() == 0) {
            this.anonymous_client_interceptors.add(clientRequestInterceptor);
        } else {
            if (this.named_client_interceptors.containsKey(clientRequestInterceptor.name())) {
                throw new DuplicateName(clientRequestInterceptor.name());
            }
            this.named_client_interceptors.put(clientRequestInterceptor.name(), clientRequestInterceptor);
        }
    }

    private void checkIsValid() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
    }

    private void checkInterceptorName(Interceptor interceptor) throws DuplicateName {
        if (interceptor.name() == null) {
            throw new DuplicateName("the name is null");
        }
    }

    public void add_ior_interceptor(IORInterceptor iORInterceptor) throws DuplicateName {
        this.checkInterceptorName(iORInterceptor);
        if (iORInterceptor.name().length() == 0) {
            this.anonymous_ior_interceptors.add(iORInterceptor);
        } else {
            if (this.named_ior_interceptors.containsKey(iORInterceptor.name())) {
                throw new DuplicateName(iORInterceptor.name());
            }
            this.named_ior_interceptors.put(iORInterceptor.name(), iORInterceptor);
        }
    }

    public void add_server_request_interceptor(ServerRequestInterceptor serverRequestInterceptor) throws DuplicateName {
        this.checkIsValid();
        this.checkInterceptorName(serverRequestInterceptor);
        if (serverRequestInterceptor.name().length() == 0) {
            this.anonymous_server_interceptors.add(serverRequestInterceptor);
        } else {
            if (this.named_server_interceptors.containsKey(serverRequestInterceptor.name())) {
                throw new DuplicateName(serverRequestInterceptor.name());
            }
            this.named_server_interceptors.put(serverRequestInterceptor.name(), serverRequestInterceptor);
        }
    }

    public int allocate_slot_id() {
        this.checkIsValid();
        return this.slot_count++;
    }

    public String[] arguments() {
        this.checkIsValid();
        return this.orb._args;
    }

    public CodecFactory codec_factory() {
        this.checkIsValid();
        try {
            return (CodecFactory)this.orb.resolve_initial_references("CodecFactory");
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            this.logger.fatalError("unexpected error", (Throwable)invalidName);
            throw new INTERNAL(invalidName.toString());
        }
    }

    public String orb_id() {
        this.checkIsValid();
        return "jacorb:2.3.0";
    }

    public void register_initial_reference(String string, Object object) throws InvalidName {
        this.checkIsValid();
        try {
            this.orb.register_initial_reference(string, object);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new InvalidName();
        }
    }

    public void register_policy_factory(int n, PolicyFactory policyFactory) {
        this.checkIsValid();
        if (policyFactory == null) {
            throw new BAD_PARAM("Actual parameter policy_factory is null!");
        }
        Integer n2 = new Integer(n);
        if (this.policy_factories.containsKey(n2)) {
            throw new BAD_INV_ORDER("A PolicyFactory for type " + n + " has already been registered!", 12, CompletionStatus.COMPLETED_MAYBE);
        }
        this.policy_factories.put(n2, policyFactory);
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        this.checkIsValid();
        try {
            return this.orb.resolve_initial_references(string);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new InvalidName();
        }
    }
}

