/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;

class FileTypeMap {
    private final Map mimeTypeMap = new HashMap();
    private final Map extensionMap = new HashMap();

    FileTypeMap() {
    }

    public void addMimeType(String mimeType, String scheme) {
        this.mimeTypeMap.put(mimeType, scheme);
    }

    public void addExtension(String extension, String scheme) {
        this.extensionMap.put(extension, scheme);
    }

    public String getScheme(FileObject file) throws FileSystemException {
        String scheme;
        FileContent content = file.getContent();
        String mimeType = (String)content.getAttribute("content-type");
        if (mimeType != null && (scheme = (String)this.mimeTypeMap.get(mimeType)) != null) {
            return scheme;
        }
        String extension = file.getName().getExtension();
        return (String)this.extensionMap.get(extension);
    }
}

