/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.FileUtil;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.DefaultFileContent;
import org.apache.commons.vfs.provider.DefaultFileSelectorInfo;
import org.apache.commons.vfs.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs.provider.UriParser;

public abstract class AbstractFileObject
implements FileObject {
    private static final FileObject[] EMPTY_FILE_ARRAY = new FileObject[0];
    private final FileName name;
    private final AbstractFileSystem fs;
    private DefaultFileContent content;
    private boolean attached;
    private FileType type;
    private AbstractFileObject parent;
    private FileObject[] children;

    protected AbstractFileObject(FileName name, AbstractFileSystem fs) {
        this.name = name;
        this.fs = fs;
    }

    protected void doAttach() throws Exception {
    }

    protected void doDetach() throws Exception {
    }

    protected abstract FileType doGetType() throws Exception;

    protected boolean doIsReadable() throws Exception {
        return true;
    }

    protected boolean doIsWriteable() throws Exception {
        return true;
    }

    protected abstract String[] doListChildren() throws Exception;

    protected void doDelete() throws Exception {
        throw new FileSystemException("vfs.provider/delete-not-supported.error");
    }

    protected void doCreateFolder() throws Exception {
        throw new FileSystemException("vfs.provider/create-folder-not-supported.error");
    }

    protected void onChildrenChanged() throws Exception {
    }

    protected void onChange() throws Exception {
    }

    protected long doGetLastModifiedTime() throws Exception {
        throw new FileSystemException("vfs.provider/get-last-modified-not-supported.error");
    }

    protected void doSetLastModifiedTime(long modtime) throws Exception {
        throw new FileSystemException("vfs.provider/set-last-modified-not-supported.error");
    }

    protected Map doGetAttributes() throws Exception {
        return Collections.EMPTY_MAP;
    }

    protected void doSetAttribute(String atttrName, Object value) throws Exception {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    protected Certificate[] doGetCertificates() throws Exception {
        return null;
    }

    protected abstract long doGetContentSize() throws Exception;

    protected abstract InputStream doGetInputStream() throws Exception;

    protected OutputStream doGetOutputStream() throws Exception {
        throw new FileSystemException("vfs.provider/write-not-supported.error");
    }

    public String toString() {
        return this.name.getURI();
    }

    public FileName getName() {
        return this.name;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public URL getURL() throws FileSystemException {
        final StringBuffer buf = new StringBuffer();
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL(UriParser.extractScheme(AbstractFileObject.this.name.getURI(), buf), null, -1, buf.toString(), new DefaultURLStreamHandler(AbstractFileObject.this.fs.getContext()));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new FileSystemException("vfs.provider/get-url.error", this.name, (Throwable)e.getException());
        }
    }

    public boolean exists() throws FileSystemException {
        this.attach();
        return this.type != FileType.IMAGINARY;
    }

    public FileType getType() throws FileSystemException {
        this.attach();
        return this.type;
    }

    public boolean isReadable() throws FileSystemException {
        try {
            this.attach();
            if (this.exists()) {
                return this.doIsReadable();
            }
            return false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-readable.error", this.name, (Throwable)exc);
        }
    }

    public boolean isWriteable() throws FileSystemException {
        try {
            this.attach();
            if (this.exists()) {
                return this.doIsWriteable();
            }
            FileObject parent = this.getParent();
            if (parent != null) {
                return parent.isWriteable();
            }
            return true;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-writeable.error", this.name, (Throwable)exc);
        }
    }

    public FileObject getParent() throws FileSystemException {
        if (this == this.fs.getRoot()) {
            if (this.fs.getParentLayer() != null) {
                return this.fs.getParentLayer().getParent();
            }
            return null;
        }
        if (this.parent == null) {
            this.parent = (AbstractFileObject)this.fs.resolveFile(this.name.getParent());
        }
        return this.parent;
    }

    public FileObject[] getChildren() throws FileSystemException {
        String[] files;
        this.attach();
        if (!this.type.hasChildren()) {
            throw new FileSystemException("vfs.provider/list-children-not-folder.error", this.name);
        }
        if (this.children != null) {
            return this.children;
        }
        try {
            files = this.doListChildren();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/list-children.error", new Object[]{this.name}, (Throwable)exc);
        }
        if (files == null || files.length == 0) {
            this.children = EMPTY_FILE_ARRAY;
        } else {
            this.children = new FileObject[files.length];
            int i = 0;
            while (i < files.length) {
                String file = files[i];
                this.children[i] = this.fs.resolveFile(this.name.resolveName(file, NameScope.CHILD));
                ++i;
            }
        }
        return this.children;
    }

    public FileObject getChild(String name) throws FileSystemException {
        this.getChildren();
        int i = 0;
        while (i < this.children.length) {
            FileObject child = this.children[i];
            if (child.getName().getBaseName().equals(name)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public FileObject resolveFile(String name, NameScope scope) throws FileSystemException {
        return this.fs.resolveFile(this.name.resolveName(name, scope));
    }

    public FileObject resolveFile(String path) throws FileSystemException {
        FileName otherName = this.name.resolveName(path);
        return this.fs.resolveFile(otherName);
    }

    private void deleteSelf() throws FileSystemException {
        if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/delete-read-only.error", this.name);
        }
        try {
            this.doDelete();
            this.handleDelete();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/delete.error", new Object[]{this.name}, (Throwable)exc);
        }
    }

    public void delete() throws FileSystemException {
        this.delete(Selectors.SELECT_SELF);
    }

    public void delete(FileSelector selector) throws FileSystemException {
        this.attach();
        if (this.type == FileType.IMAGINARY) {
            return;
        }
        ArrayList files = new ArrayList();
        this.findFiles(selector, true, files);
        int count = files.size();
        int i = 0;
        while (i < count) {
            AbstractFileObject file = (AbstractFileObject)files.get(i);
            file.attach();
            if (file.type != FileType.FOLDER || file.getChildren().length == 0) {
                file.deleteSelf();
            }
            ++i;
        }
    }

    public void createFile() throws FileSystemException {
        try {
            this.getOutputStream().close();
            this.endOutput();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/create-file.error", this.name, (Throwable)e);
        }
    }

    public void createFolder() throws FileSystemException {
        this.attach();
        if (this.type == FileType.FOLDER) {
            return;
        }
        if (this.type != FileType.IMAGINARY) {
            throw new FileSystemException("vfs.provider/create-folder-mismatched-type.error", this.name);
        }
        if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/create-folder-read-only.error", this.name);
        }
        FileObject parent = this.getParent();
        if (parent != null) {
            parent.createFolder();
        }
        try {
            this.doCreateFolder();
            this.handleCreate(FileType.FOLDER);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/create-folder.error", this.name, (Throwable)exc);
        }
    }

    public void copyFrom(FileObject file, FileSelector selector) throws FileSystemException {
        if (!file.exists()) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", file);
        }
        if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/copy-read-only.error", new Object[]{file.getType(), file.getName(), this}, null);
        }
        ArrayList files = new ArrayList();
        ((AbstractFileObject)file).findFiles(selector, false, files);
        int count = files.size();
        int i = 0;
        while (i < count) {
            FileObject srcFile = (FileObject)files.get(i);
            String relPath = file.getName().getRelativeName(srcFile.getName());
            FileObject destFile = this.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
            if (destFile.exists() && destFile.getType() != srcFile.getType()) {
                destFile.delete(Selectors.SELECT_ALL);
            }
            try {
                if (srcFile.getType().hasContent()) {
                    FileUtil.copyContent(srcFile, destFile);
                } else if (srcFile.getType().hasChildren()) {
                    destFile.createFolder();
                }
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/copy-file.error", new Object[]{srcFile, destFile}, (Throwable)e);
            }
            ++i;
        }
    }

    public FileObject[] findFiles(FileSelector selector) throws FileSystemException {
        ArrayList list = new ArrayList();
        this.findFiles(selector, true, list);
        return list.toArray(new FileObject[list.size()]);
    }

    public FileContent getContent() throws FileSystemException {
        this.attach();
        if (this.content == null) {
            this.content = new DefaultFileContent(this);
        }
        return this.content;
    }

    public void close() throws FileSystemException {
        FileSystemException exc = null;
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (FileSystemException e) {
                exc = e;
            }
        }
        try {
            this.detach();
        }
        catch (Exception e) {
            exc = new FileSystemException("vfs.provider/close.error", this.name, (Throwable)e);
        }
        if (exc != null) {
            throw exc;
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        this.attach();
        if (!this.type.hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.name);
        }
        if (!this.isReadable()) {
            throw new FileSystemException("vfs.provider/read-not-readable.error", this.name);
        }
        try {
            return this.doGetInputStream();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/read.error", this.name, (Throwable)exc);
        }
    }

    public OutputStream getOutputStream() throws FileSystemException {
        FileObject parent;
        this.attach();
        if (this.type != FileType.IMAGINARY && !this.type.hasContent()) {
            throw new FileSystemException("vfs.provider/write-not-file.error", this.name);
        }
        if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/write-read-only.error", this.name);
        }
        if (this.type == FileType.IMAGINARY && (parent = this.getParent()) != null) {
            parent.createFolder();
        }
        try {
            return this.doGetOutputStream();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/write.error", new Object[]{this.name}, (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach() throws Exception {
        if (this.attached) {
            try {
                this.doDetach();
                Object var2_1 = null;
                this.attached = false;
                this.type = null;
                this.children = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.attached = false;
                this.type = null;
                this.children = null;
                throw throwable;
            }
        }
    }

    private void attach() throws FileSystemException {
        if (this.attached) {
            return;
        }
        try {
            this.doAttach();
            this.attached = true;
            this.type = this.doGetType();
            if (this.type == null) {
                this.type = FileType.IMAGINARY;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/get-type.error", new Object[]{this.name}, (Throwable)exc);
        }
    }

    protected void endOutput() throws Exception {
        if (this.type == FileType.IMAGINARY) {
            this.handleCreate(FileType.FILE);
        } else {
            this.onChange();
        }
    }

    protected void handleCreate(FileType newType) throws Exception {
        if (this.attached) {
            this.type = newType;
            this.children = EMPTY_FILE_ARRAY;
            this.onChange();
        }
        this.notifyParent();
        this.fs.fireFileCreated(this);
    }

    protected void handleDelete() throws Exception {
        if (this.attached) {
            this.type = FileType.IMAGINARY;
            this.children = null;
            this.onChange();
        }
        this.notifyParent();
        this.fs.fireFileDeleted(this);
    }

    protected void childrenChanged() throws Exception {
        this.children = null;
        this.onChildrenChanged();
    }

    private void notifyParent() throws Exception {
        if (this.parent == null) {
            this.parent = (AbstractFileObject)this.fs.getFile(this.name.getParent());
        }
        if (this.parent != null) {
            this.parent.childrenChanged();
        }
    }

    private void findFiles(FileSelector selector, boolean depthwise, List selected) throws FileSystemException {
        try {
            if (this.exists()) {
                DefaultFileSelectorInfo info = new DefaultFileSelectorInfo();
                info.setBaseFolder(this);
                info.setDepth(0);
                info.setFile(this);
                AbstractFileObject.traverse(info, selector, depthwise, selected);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/find-files.error", this.name, (Throwable)e);
        }
    }

    private static void traverse(DefaultFileSelectorInfo fileInfo, FileSelector selector, boolean depthwise, List selected) throws Exception {
        FileObject file = fileInfo.getFile();
        int index = selected.size();
        if (file.getType().hasChildren() && selector.traverseDescendents(fileInfo)) {
            int curDepth = fileInfo.getDepth();
            fileInfo.setDepth(curDepth + 1);
            FileObject[] children = file.getChildren();
            int i = 0;
            while (i < children.length) {
                FileObject child = children[i];
                fileInfo.setFile(child);
                AbstractFileObject.traverse(fileInfo, selector, depthwise, selected);
                ++i;
            }
            fileInfo.setFile(file);
            fileInfo.setDepth(curDepth);
        }
        if (selector.includeFile(fileInfo)) {
            if (depthwise) {
                selected.add(file);
            } else {
                selected.add(index, file);
            }
        }
    }
}

