/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileProvider;

public abstract class AbstractOriginatingFileProvider
extends AbstractFileProvider {
    public FileObject findFile(FileObject baseFile, String uri) throws FileSystemException {
        FileName name;
        try {
            name = this.parseUri(uri);
        }
        catch (FileSystemException exc) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", uri, (Throwable)exc);
        }
        return this.findFile(name);
    }

    private FileObject findFile(FileName name) throws FileSystemException {
        FileName rootName = name.resolveName("/");
        FileSystem fs = this.findFileSystem(rootName);
        if (fs == null) {
            fs = this.doCreateFileSystem(rootName);
            this.addFileSystem(rootName, fs);
        }
        return fs.resolveFile(name.getPath());
    }

    protected abstract FileName parseUri(String var1) throws FileSystemException;

    protected abstract FileSystem doCreateFileSystem(FileName var1) throws FileSystemException;
}

