/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileSystemException;

public final class UriParser {
    private static final char SEPARATOR_CHAR = '/';
    public static final char[] separators = new char[]{'\\'};

    private UriParser() {
    }

    public static String extractFirstElement(StringBuffer name) {
        int len = name.length();
        if (len < 1) {
            return null;
        }
        int startPos = 0;
        if (name.charAt(0) == '/') {
            startPos = 1;
        }
        int pos = startPos;
        while (pos < len) {
            if (name.charAt(pos) == '/') {
                String elem = name.substring(startPos, pos);
                name.delete(startPos, pos + 1);
                return elem;
            }
            ++pos;
        }
        String elem = name.substring(startPos);
        name.setLength(0);
        return elem;
    }

    public static void normalisePath(StringBuffer path) throws FileSystemException {
        if (path.length() == 0) {
            return;
        }
        UriParser.fixSeparators(path);
        int startFirstElem = 0;
        if (path.charAt(0) == '/') {
            if (path.length() == 1) {
                return;
            }
            startFirstElem = 1;
        }
        int startElem = startFirstElem;
        int maxlen = path.length();
        while (startElem < maxlen) {
            int endElem = startElem;
            while (endElem < maxlen && path.charAt(endElem) != '/') {
                ++endElem;
            }
            int elemLen = endElem - startElem;
            if (elemLen == 0) {
                path.delete(endElem, endElem + 1);
                maxlen = path.length();
                continue;
            }
            if (elemLen == 1 && path.charAt(startElem) == '.') {
                path.delete(startElem, endElem + 1);
                maxlen = path.length();
                continue;
            }
            if (elemLen == 2 && path.charAt(startElem) == '.' && path.charAt(startElem + 1) == '.') {
                if (startElem == startFirstElem) {
                    throw new FileSystemException("vfs.provider/invalid-relative-path.error");
                }
                int pos = startElem - 2;
                while (pos >= 0 && path.charAt(pos) != '/') {
                    --pos;
                }
                startElem = pos + 1;
                path.delete(startElem, endElem + 1);
                maxlen = path.length();
                continue;
            }
            startElem = endElem + 1;
        }
        if (maxlen > 0 && path.charAt(maxlen - 1) == '/' && maxlen > 1) {
            path.delete(maxlen - 1, maxlen);
        }
    }

    public static boolean fixSeparators(StringBuffer name) {
        if (separators.length == 0) {
            return false;
        }
        boolean changed = false;
        int maxlen = name.length();
        int i = 0;
        while (i < maxlen) {
            char ch = name.charAt(i);
            int j = 0;
            while (j < separators.length) {
                char separator = separators[j];
                if (ch == separator) {
                    name.setCharAt(i, '/');
                    changed = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return changed;
    }

    public static String extractScheme(String uri) {
        return UriParser.extractScheme(uri, null);
    }

    public static String extractScheme(String uri, StringBuffer buffer) {
        if (buffer != null) {
            buffer.setLength(0);
            buffer.append(uri);
        }
        int maxPos = uri.length();
        int pos = 0;
        while (pos < maxPos) {
            char ch = uri.charAt(pos);
            if (ch == ':') {
                String scheme = uri.substring(0, pos);
                if (buffer != null) {
                    buffer.delete(0, pos + 1);
                }
                return scheme;
            }
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (pos <= 0 || (ch < '0' || ch > '9') && ch != '+' && ch != '-' && ch != '.')) break;
            ++pos;
        }
        return null;
    }

    public static String decode(String encodedStr) throws FileSystemException {
        if (encodedStr == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(encodedStr);
        UriParser.decode(buffer, 0, buffer.length());
        return buffer.toString();
    }

    public static void decode(StringBuffer buffer, int offset, int length) throws FileSystemException {
        int index = offset;
        int count = length;
        while (count > 0) {
            char ch = buffer.charAt(index);
            if (ch == '%') {
                if (count < 3) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", buffer.substring(index, index + count));
                }
                int dig1 = Character.digit(buffer.charAt(index + 1), 16);
                int dig2 = Character.digit(buffer.charAt(index + 2), 16);
                if (dig1 == -1 || dig2 == -1) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", buffer.substring(index, index + 3));
                }
                char value = (char)(dig1 << 4 | dig2);
                buffer.setCharAt(index, value);
                buffer.delete(index + 1, index + 3);
                count -= 2;
            }
            --count;
            ++index;
        }
    }

    public static void appendEncoded(StringBuffer buffer, String unencodedValue, char[] reserved) {
        int offset = buffer.length();
        buffer.append(unencodedValue);
        UriParser.encode(buffer, offset, unencodedValue.length(), reserved);
    }

    public static void encode(StringBuffer buffer, int offset, int length, char[] reserved) {
        int index = offset;
        int count = length;
        while (count > 0) {
            char ch = buffer.charAt(index);
            boolean match = ch == '%';
            int i = 0;
            while (!match && i < reserved.length) {
                if (ch == reserved[i]) {
                    match = true;
                }
                ++i;
            }
            if (match) {
                char[] digits = new char[]{Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
                buffer.setCharAt(index, '%');
                buffer.insert(index + 1, digits);
                index += 2;
            }
            ++index;
            --count;
        }
    }
}

