/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.File;
import java.io.FilePermission;
import java.util.Collection;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.local.LocalFile;

public final class LocalFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final String rootFile;

    public LocalFileSystem(FileName rootName, String rootFile) {
        super(rootName, null);
        this.rootFile = rootFile;
    }

    protected FileObject createFile(FileName name) {
        String fileName = this.rootFile + name.getPath();
        return new LocalFile(this, fileName, name);
    }

    protected void addCapabilities(Collection caps) {
        caps.add(Capability.CREATE);
        caps.add(Capability.DELETE);
        caps.add(Capability.GET_TYPE);
        caps.add(Capability.GET_LAST_MODIFIED);
        caps.add(Capability.SET_LAST_MODIFIED);
        caps.add(Capability.LIST_CHILDREN);
        caps.add(Capability.READ_CONTENT);
        caps.add(Capability.URI);
        caps.add(Capability.WRITE_CONTENT);
    }

    protected File doReplicateFile(FileObject fileObject, FileSelector selector) throws Exception {
        LocalFile localFile = (LocalFile)fileObject;
        File file = localFile.getLocalFile();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            FilePermission requiredPerm = new FilePermission(file.getAbsolutePath(), "read");
            sm.checkPermission(requiredPerm);
        }
        return file;
    }
}

