/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.File;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs.util.Os;

public class SftpFileProvider
extends AbstractOriginatingFileProvider {
    private static final String SSH_DIR_NAME = ".ssh";
    private JSch jSch = new JSch();

    protected FileSystem doCreateFileSystem(FileName rootName) {
        return new SftpFileSystem((GenericFileName)rootName, this.getJSch());
    }

    private File findSshDir() {
        File sshDir;
        String sshDirPath = System.getProperty("vfs.sftp.sshdir");
        if (sshDirPath != null && (sshDir = new File(sshDirPath)).exists()) {
            return sshDir;
        }
        sshDir = new File(System.getProperty("user.home"), SSH_DIR_NAME);
        if (sshDir.exists()) {
            return sshDir;
        }
        if (Os.isFamily(Os.OS_FAMILY_WINDOWS)) {
            String userName = System.getProperty("user.name");
            sshDir = new File("C:\\cygwin\\home\\" + userName + "\\" + SSH_DIR_NAME);
            if (sshDir.exists()) {
                return sshDir;
            }
        }
        return new File("");
    }

    private JSch getJSch() {
        return this.jSch;
    }

    public void init() throws FileSystemException {
        File privateKeyFile;
        File sshDir = this.findSshDir();
        File knownHostsFile = new File(sshDir, "known_hosts");
        if (knownHostsFile.isFile() && knownHostsFile.canRead()) {
            this.getJSch().setKnownHosts(knownHostsFile.getAbsolutePath());
        }
        if ((privateKeyFile = new File(sshDir, "id_rsa")).isFile() && privateKeyFile.canRead()) {
            try {
                this.getJSch().addIdentity(privateKeyFile.getAbsolutePath());
            }
            catch (JSchException e) {
                throw new FileSystemException("vfs.provider.sftp/load-private-key.error", privateKeyFile, (Throwable)e);
            }
        }
    }

    protected FileName parseUri(String uri) throws FileSystemException {
        return GenericFileName.parseUri(uri, 22);
    }
}

