/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.smb;

import java.io.InputStream;
import java.io.OutputStream;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.smb.SmbFileSystem;

class SmbFileObject
extends AbstractFileObject
implements FileObject {
    private final String fileName;
    private SmbFile file;

    protected SmbFileObject(FileName name, SmbFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileName = name.getURI();
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            this.file = new SmbFile(this.fileName);
        }
    }

    protected FileType doGetType() throws Exception {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        throw new FileSystemException("vfs.provider.smb/get-type.error", this.getName());
    }

    protected String[] doListChildren() throws Exception {
        return this.file.list();
    }

    protected void doDelete() throws Exception {
        this.file.delete();
    }

    protected void doCreateFolder() throws Exception {
        this.file.mkdir();
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.file.getLastModified();
    }

    protected InputStream doGetInputStream() throws Exception {
        return new SmbFileInputStream(this.file);
    }

    protected OutputStream doGetOutputStream() throws Exception {
        return new SmbFileOutputStream(this.file);
    }
}

