/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.zip;

import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.zip.ZipFileSystem;

public class ZipFileObject
extends AbstractFileObject
implements FileObject {
    private final HashSet children = new HashSet();
    protected final ZipFile file;
    protected ZipEntry entry;
    private FileType type;

    public ZipFileObject(FileName name, ZipEntry entry, ZipFile zipFile, ZipFileSystem fs) {
        super(name, fs);
        this.setZipEntry(entry);
        this.file = zipFile;
        if (this.file == null) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void setZipEntry(ZipEntry entry) {
        if (this.entry != null) {
            return;
        }
        this.type = entry == null || entry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = entry;
    }

    public void attachChild(FileName childName) {
        this.children.add(childName.getBaseName());
    }

    public boolean isWriteable() {
        return false;
    }

    protected FileType doGetType() {
        return this.type;
    }

    protected String[] doListChildren() {
        return this.children.toArray(new String[this.children.size()]);
    }

    protected long doGetContentSize() {
        return this.entry.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.entry.getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.file.getInputStream(this.entry);
    }
}

