/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.zip;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.zip.ZipFileObject;

public class ZipFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final File file;
    protected final ZipFile zipFile;

    public ZipFileSystem(FileName rootName, FileObject parentLayer) throws FileSystemException {
        super(rootName, parentLayer);
        this.file = parentLayer.getFileSystem().replicateFile(parentLayer, Selectors.SELECT_SELF);
        if (!this.file.exists()) {
            this.zipFile = null;
            return;
        }
        this.zipFile = this.createZipFile(this.file);
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipFileObject fileObj;
            ZipEntry entry = entries.nextElement();
            FileName name = rootName.resolveName(entry.getName());
            if (entry.isDirectory() && this.getFile(name) != null) {
                fileObj = (ZipFileObject)this.getFile(name);
                fileObj.setZipEntry(entry);
                continue;
            }
            fileObj = this.createZipFileObject(name, entry, this.zipFile);
            this.putFile(fileObj);
            ZipFileObject parent = null;
            FileName parentName = name.getParent();
            while (parentName != null) {
                parent = (ZipFileObject)this.getFile(parentName);
                if (parent == null) {
                    parent = this.createZipFileObject(parentName, null, this.zipFile);
                    this.putFile(parent);
                }
                parent.attachChild(fileObj.getName());
                fileObj = parent;
                parentName = parentName.getParent();
            }
        }
    }

    protected ZipFileObject createZipFileObject(FileName name, ZipEntry entry, ZipFile file) {
        return new ZipFileObject(name, entry, file, this);
    }

    protected ZipFile createZipFile(File file) throws FileSystemException {
        try {
            return new ZipFile(file);
        }
        catch (IOException ioe) {
            throw new FileSystemException("vfs.provider.zip/open-zip-file.error", file, (Throwable)ioe);
        }
    }

    public void close() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
        catch (IOException e) {
            this.getLogger().warn((Object)("vfs.provider.zip/close-zip-file.error :" + this.file), (Throwable)e);
        }
        super.close();
    }

    protected void addCapabilities(Collection caps) {
        caps.add(Capability.GET_LAST_MODIFIED);
        caps.add(Capability.GET_TYPE);
        caps.add(Capability.LIST_CHILDREN);
        caps.add(Capability.READ_CONTENT);
        caps.add(Capability.URI);
    }

    protected FileObject createFile(FileName name) {
        return new ZipFileObject(name, null, null, this);
    }
}

