/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;

public class IntegerRangeTest
extends ComputedExpression {
    Expression value;
    Expression min;
    Expression max;

    public IntegerRangeTest(Expression expression, Expression expression2, Expression expression3) {
        this.value = expression;
        this.min = expression2;
        this.max = expression3;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Iterator iterateSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.value, this.min, this.max};
        return Arrays.asList(expressionArray).iterator();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        NumericValue numericValue;
        AtomicValue atomicValue2 = (AtomicValue)this.value.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return BooleanValue.FALSE;
        }
        NumericValue numericValue2 = (NumericValue)atomicValue2.getPrimitiveValue();
        if (numericValue2.compareTo(numericValue = (NumericValue)(atomicValue = (AtomicValue)this.min.evaluateItem(xPathContext)).getPrimitiveValue()) < 0) {
            return BooleanValue.FALSE;
        }
        AtomicValue atomicValue3 = (AtomicValue)this.max.evaluateItem(xPathContext);
        NumericValue numericValue3 = (NumericValue)atomicValue3.getPrimitiveValue();
        return BooleanValue.get(numericValue2.compareTo(numericValue3) <= 0);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "rangeTest min<value<max");
        this.min.display(n + 1, printStream, configuration);
        this.value.display(n + 1, printStream, configuration);
        this.max.display(n + 1, printStream, configuration);
    }
}

