/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;

public class NumberFormatter
implements Serializable {
    public static boolean methodInitialized = false;
    public static Method isLetterOrDigitMethod = null;
    private static int[] nonBmpZeroDigits = new int[]{66720, 67534, 67544, 67554, 67564, 67574};
    private ArrayList formatTokens;
    private ArrayList punctuationTokens;
    private boolean startsWithPunctuation;
    static /* synthetic */ Class class$java$lang$Character;

    public void prepare(String string) {
        if (string.length() == 0) {
            string = "1";
        }
        this.formatTokens = new ArrayList(10);
        this.punctuationTokens = new ArrayList(10);
        int n = string.length();
        int n2 = 0;
        boolean bl = true;
        this.startsWithPunctuation = true;
        while (n2 < n) {
            String string2;
            int n3 = string.charAt(n2);
            int n4 = n2++;
            if (XMLChar.isHighSurrogate(n3)) {
                n3 = XMLChar.supplemental((char)n3, string.charAt(n2));
            }
            while (NumberFormatter.isLetterOrDigit(n3) && ++n2 != n) {
                n3 = string.charAt(n2);
                if (!XMLChar.isHighSurrogate(n3)) continue;
                n3 = XMLChar.supplemental((char)n3, string.charAt(++n2));
            }
            if (n2 > n4) {
                string2 = string.substring(n4, n2);
                this.formatTokens.add(string2);
                if (bl) {
                    this.punctuationTokens.add(".");
                    this.startsWithPunctuation = false;
                    bl = false;
                }
            }
            if (n2 == n) break;
            n4 = n2;
            n3 = string.charAt(n2);
            if (XMLChar.isHighSurrogate(n3)) {
                n3 = XMLChar.supplemental((char)n3, string.charAt(++n2));
            }
            while (!NumberFormatter.isLetterOrDigit(n3)) {
                bl = false;
                if (++n2 == n) break;
                n3 = string.charAt(n2);
                if (!XMLChar.isHighSurrogate(n3)) continue;
                n3 = XMLChar.supplemental((char)n3, string.charAt(++n2));
            }
            if (n2 <= n4) continue;
            string2 = string.substring(n4, n2);
            this.punctuationTokens.add(string2);
        }
        if (this.formatTokens.size() == 0) {
            this.formatTokens.add("1");
            if (this.punctuationTokens.size() == 1) {
                this.punctuationTokens.add(this.punctuationTokens.get(0));
            }
        }
    }

    private static boolean isLetterOrDigit(int n) {
        Object[] objectArray;
        if (n <= 65535) {
            return Character.isLetterOrDigit((char)n);
        }
        if (!methodInitialized) {
            try {
                objectArray = new Class[]{Integer.TYPE};
                isLetterOrDigitMethod = (class$java$lang$Character == null ? (class$java$lang$Character = NumberFormatter.class$("java.lang.Character")) : class$java$lang$Character).getDeclaredMethod("isLetterOrDigit", (Class<?>[])objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (isLetterOrDigitMethod != null) {
            try {
                objectArray = new Object[]{new Integer(n)};
                Boolean bl = (Boolean)isLetterOrDigitMethod.invoke(null, objectArray);
                return bl;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
        }
        return NumberFormatter.getDigitValue(n) != -1;
    }

    public static int getDigitValue(int n) {
        if (n <= 65535) {
            if (Character.isDigit((char)n)) {
                return Character.getNumericValue((char)n);
            }
            return -1;
        }
        for (int i = 0; i < nonBmpZeroDigits.length; ++i) {
            if (n < nonBmpZeroDigits[i] || n > nonBmpZeroDigits[i] + 9) continue;
            return n - nonBmpZeroDigits[i];
        }
        return -1;
    }

    public CharSequence format(List list, int n, String string, String string2, String string3, Numberer numberer) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(20);
        int n2 = 0;
        int n3 = 0;
        if (this.startsWithPunctuation) {
            fastStringBuffer.append((String)this.punctuationTokens.get(n3));
        }
        while (n2 < list.size()) {
            String string4;
            Object e;
            if (n2 > 0) {
                if (n3 == 0 && this.startsWithPunctuation) {
                    fastStringBuffer.append(".");
                } else {
                    fastStringBuffer.append((String)this.punctuationTokens.get(n3));
                }
            }
            if ((e = list.get(n2++)) instanceof Long) {
                long l = (Long)e;
                string4 = numberer.format(l, (String)this.formatTokens.get(n3), n, string, string2, string3);
            } else {
                string4 = e.toString();
            }
            fastStringBuffer.append(string4);
            if (++n3 != this.formatTokens.size()) continue;
            --n3;
        }
        if (this.punctuationTokens.size() > this.formatTokens.size()) {
            fastStringBuffer.append((String)this.punctuationTokens.get(this.punctuationTokens.size() - 1));
        }
        return fastStringBuffer.condense();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

