/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;

public abstract class SOAPFactory {
    private static Logger log = Logger.getLogger(SOAPFactory.class);
    private static final String DEFAULT_SOAP_FACTORY = "org.jboss.ws.soap.SOAPFactoryImpl";
    private static final String[] alternativeFactories = new String[]{"org.jboss.axis.soap.SOAPFactoryImpl"};

    public static SOAPFactory newInstance() throws SOAPException {
        PropertyAccessAction action = new PropertyAccessAction(SOAPFactory.class.getName(), DEFAULT_SOAP_FACTORY);
        String factoryName = (String)AccessController.doPrivileged(action);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> factoryClass = loader.loadClass(factoryName);
                return (SOAPFactory)factoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                if (!factoryName.equals(DEFAULT_SOAP_FACTORY)) {
                    throw e;
                }
                for (int i = 0; i < alternativeFactories.length; ++i) {
                    factoryName = alternativeFactories[i];
                    try {
                        Class<?> factoryClass = loader.loadClass(factoryName);
                        return (SOAPFactory)factoryClass.newInstance();
                    }
                    catch (ClassNotFoundException e1) {
                        log.debug("Cannot load factory: " + factoryName);
                        continue;
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new SOAPException("Failed to create SOAPFactory: " + factoryName, t);
        }
        throw new SOAPException("Cannot find SOAPFactory implementation");
    }

    public abstract Detail createDetail() throws SOAPException;

    public abstract SOAPElement createElement(String var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1, String var2, String var3) throws SOAPException;

    public abstract SOAPElement createElement(Name var1) throws SOAPException;

    public abstract Name createName(String var1) throws SOAPException;

    public abstract Name createName(String var1, String var2, String var3) throws SOAPException;

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;
        private String defaultValue;

        PropertyAccessAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

