/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.interfaces;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.rmi.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.transaction.SystemException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.pooled.interfaces.OptimizedObjectInputStream;
import org.jboss.invocation.pooled.interfaces.OptimizedObjectOutputStream;
import org.jboss.invocation.pooled.interfaces.PooledMarshalledInvocation;
import org.jboss.invocation.pooled.interfaces.ServerAddress;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionPropagationContextFactory;

public class PooledInvokerProxy
implements Invoker,
Externalizable {
    private static final Logger log = Logger.getLogger(PooledInvokerProxy.class);
    private static final long serialVersionUID = -1456509931095566410L;
    private static final int WIRE_VERSION = 1;
    protected static TransactionPropagationContextFactory tpcFactory = null;
    public static long getSocketTime = 0L;
    public static long readTime = 0L;
    public static long writeTime = 0L;
    public static long serializeTime = 0L;
    public static long deserializeTime = 0L;
    public static long usedPooled = 0L;
    private static int inUseCount = 0;
    public static int MAX_RETRIES = 10;
    protected static final Map connectionPools = new ConcurrentReaderHashMap();
    protected ServerAddress address;
    protected LinkedList pool = null;
    protected int maxPoolSize;
    protected int retryCount = 1;
    private transient boolean trace;

    public static void setTPCFactory(TransactionPropagationContextFactory tpcf) {
        tpcFactory = tpcf;
    }

    public static void clearStats() {
        getSocketTime = 0L;
        readTime = 0L;
        writeTime = 0L;
        serializeTime = 0L;
        deserializeTime = 0L;
        usedPooled = 0L;
    }

    public static long getInUseCount() {
        return inUseCount;
    }

    public static long getUsedPooled() {
        return usedPooled;
    }

    public static int getTotalPoolCount() {
        int count = 0;
        Iterator iter = connectionPools.values().iterator();
        while (iter.hasNext()) {
            List pool = (List)iter.next();
            if (pool == null) continue;
            count += pool.size();
        }
        return count;
    }

    public long getPoolCount() {
        return this.pool.size();
    }

    public PooledInvokerProxy() {
        this.trace = log.isTraceEnabled();
    }

    public PooledInvokerProxy(ServerAddress sa, int maxPoolSize) {
        this(sa, maxPoolSize, MAX_RETRIES);
    }

    public PooledInvokerProxy(ServerAddress sa, int maxPoolSize, int retryCount) {
        this.address = sa;
        this.maxPoolSize = maxPoolSize;
        this.retryCount = retryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool(ServerAddress sa) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("clearPool, sa: " + sa);
        }
        try {
            LinkedList thepool = (LinkedList)connectionPools.get(sa);
            if (thepool == null) {
                return;
            }
            LinkedList linkedList = thepool;
            synchronized (linkedList) {
                int size = thepool.size();
                for (int i = 0; i < size; ++i) {
                    ClientSocket socket = (ClientSocket)thepool.removeFirst();
                    try {
                        if (trace) {
                            log.trace("Closing, ClientSocket: " + socket.socket);
                        }
                        socket.socket.close();
                        socket.socket = null;
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPools() {
        Map map = connectionPools;
        synchronized (map) {
            Iterator it = connectionPools.keySet().iterator();
            while (it.hasNext()) {
                ServerAddress sa = (ServerAddress)it.next();
                PooledInvokerProxy.clearPool(sa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPool() {
        Map map = connectionPools;
        synchronized (map) {
            this.pool = (LinkedList)connectionPools.get(this.address);
            if (this.pool == null) {
                this.pool = new LinkedList();
                connectionPools.put(this.address, this.pool);
            }
        }
    }

    protected ClientSocket getConnection() throws Exception {
        Socket socket = null;
        for (int i = 0; i < this.retryCount; ++i) {
            ClientSocket pooled = this.getPooledConnection();
            if (pooled != null) {
                ++usedPooled;
                ++inUseCount;
                return pooled;
            }
            try {
                if (this.trace) {
                    log.trace("Connecting to addr: " + this.address.address + ", port: " + this.address.port + ",clientSocketFactory: " + this.address.clientSocketFactory);
                }
                socket = this.address.clientSocketFactory != null ? this.address.clientSocketFactory.createSocket(this.address.address, this.address.port) : new Socket(this.address.address, this.address.port);
                if (!this.trace) break;
                log.trace("Connected: " + socket);
                break;
            }
            catch (ConnectException ex) {
                if (this.trace) {
                    log.trace("Connect failed", ex);
                }
                if (i + 1 >= this.retryCount) {
                    throw ex;
                }
                Thread.sleep(1L);
                continue;
            }
        }
        if (socket == null) {
            throw new ConnectException("Failed to obtain a socket, tries=" + this.retryCount);
        }
        ++inUseCount;
        socket.setTcpNoDelay(this.address.enableTcpNoDelay);
        return new ClientSocket(socket, this.address.timeout);
    }

    protected synchronized ClientSocket getPooledConnection() {
        ClientSocket socket = null;
        while (this.pool.size() > 0) {
            socket = (ClientSocket)this.pool.removeFirst();
            try {
                boolean ACK = true;
                socket.out.writeByte(1);
                socket.out.flush();
                socket.in.readByte();
                if (this.trace) {
                    log.trace("Using pooled socket: " + socket);
                }
                return socket;
            }
            catch (Exception ex) {
                if (this.trace) {
                    log.trace("Failed to validate pooled socket: " + socket);
                }
                try {
                    socket.socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    protected synchronized boolean returnConnection(ClientSocket socket) {
        boolean pooled = false;
        if (this.pool.size() < this.maxPoolSize) {
            this.pool.add(socket);
            --inUseCount;
            pooled = true;
        }
        return pooled;
    }

    public String getServerHostName() throws Exception {
        return this.address.address;
    }

    public Object getTransactionPropagationContext() throws SystemException {
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    public Object invoke(Invocation invocation) throws Exception {
        boolean trace = log.isTraceEnabled();
        PooledMarshalledInvocation mi = new PooledMarshalledInvocation(invocation);
        mi.setTransactionPropagationContext(this.getTransactionPropagationContext());
        Object response = null;
        long start = System.currentTimeMillis();
        ClientSocket socket = this.getConnection();
        long end = System.currentTimeMillis() - start;
        getSocketTime += end;
        if (socket.sessionID != null) {
            mi.setValue("SESSION_ID", socket.sessionID);
            if (trace) {
                log.trace("Added SESSION_ID to invocation");
            }
        }
        try {
            if (trace) {
                log.trace("Sending invocation to: " + mi.getObjectName());
            }
            socket.out.writeObject(mi);
            socket.out.reset();
            socket.out.writeObject(Boolean.TRUE);
            socket.out.flush();
            socket.out.reset();
            end = System.currentTimeMillis() - start;
            writeTime += end;
            start = System.currentTimeMillis();
            response = socket.in.readObject();
            socket.in.readObject();
            end = System.currentTimeMillis() - start;
            readTime += end;
        }
        catch (Exception ex) {
            try {
                socket.socket.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw new ConnectException("Failed to communicate", ex);
        }
        if (!this.returnConnection(socket)) {
            if (trace) {
                log.trace("Closing unpooled socket: " + socket);
            }
            try {
                socket.socket.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        try {
            if (response instanceof Exception) {
                throw (Exception)response;
            }
            if (response instanceof MarshalledObject) {
                return ((MarshalledObject)response).get();
            }
            return response;
        }
        catch (ServerException ex) {
            if (ex.detail instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)ex.detail;
            }
            if (ex.detail instanceof TransactionRolledbackException) {
                throw (TransactionRolledbackException)ex.detail;
            }
            throw ex;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.address);
        out.writeInt(this.maxPoolSize);
        out.writeInt(1);
        out.writeInt(this.retryCount);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.trace = log.isTraceEnabled();
        this.address = (ServerAddress)in.readObject();
        this.maxPoolSize = in.readInt();
        int version = 0;
        try {
            version = in.readInt();
        }
        catch (EOFException e) {
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        switch (version) {
            case 0: {
                this.retryCount = MAX_RETRIES;
                break;
            }
            case 1: {
                this.readVersion1(in);
                break;
            }
        }
        this.initPool();
    }

    private void readVersion1(ObjectInput in) throws IOException {
        this.retryCount = in.readInt();
    }

    protected static class ClientSocket
    implements HandshakeCompletedListener {
        public ObjectOutputStream out;
        public ObjectInputStream in;
        public Socket socket;
        public int timeout;
        public String sessionID;
        private boolean handshakeComplete = false;
        private boolean trace;

        public ClientSocket(Socket socket, int timeout) throws Exception {
            this.socket = socket;
            this.trace = log.isTraceEnabled();
            boolean needHandshake = false;
            if (socket instanceof SSLSocket) {
                SSLSocket ssl = (SSLSocket)socket;
                ssl.addHandshakeCompletedListener(this);
                if (this.trace) {
                    log.trace("Starting SSL handshake");
                }
                needHandshake = true;
                this.handshakeComplete = false;
                ssl.startHandshake();
            }
            socket.setSoTimeout(timeout);
            this.timeout = timeout;
            this.out = new OptimizedObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.out.flush();
            this.in = new OptimizedObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            if (needHandshake) {
                socket.setSoTimeout(1000);
                for (int n = 0; !this.handshakeComplete && n < 60; ++n) {
                    try {
                        int b = this.in.read();
                        continue;
                    }
                    catch (SSLException e) {
                        if (this.trace) {
                            log.trace("Error while waiting for handshake to complete", e);
                        }
                        throw e;
                    }
                    catch (IOException e) {
                        if (!this.trace) continue;
                        log.trace("Handshaked read()", e);
                    }
                }
                if (!this.handshakeComplete) {
                    throw new SSLException("Handshaked failed to complete in 60 seconds");
                }
                socket.setSoTimeout(timeout);
            }
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            this.handshakeComplete = true;
            byte[] id = event.getSession().getId();
            try {
                this.sessionID = new String(id, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn("Failed to create session id using UTF-8, using default", e);
                this.sessionID = new String(id);
            }
            if (this.trace) {
                log.trace("handshakeCompleted, event=" + event + ", sessionID=" + this.sessionID);
            }
        }

        protected void finalize() {
            if (this.socket != null) {
                if (this.trace) {
                    log.trace("Closing socket in finalize: " + this.socket);
                }
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

