/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.mejb;

import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.management.mejb.ClientNotificationListener;
import org.jboss.management.mejb.MEJB;

public class JMSClientNotificationListener
extends ClientNotificationListener
implements MessageListener {
    public JMSClientNotificationListener(ObjectName pSender, NotificationListener pClientListener, Object pHandback, NotificationFilter pFilter, String pQueueJNDIName, String pServerName, MEJB pConnector) throws JMSException, JMException, NamingException, RemoteException {
        super(pSender, pClientListener, pHandback);
        QueueConnection lConnection = this.getQueueConnection(pServerName, pQueueJNDIName);
        QueueSession lSession = lConnection.createQueueSession(false, 1);
        TemporaryQueue lQueue = lSession.createTemporaryQueue();
        this.createListener(pConnector, "org.jboss.management.mejb.JMSNotificationListener", new Object[]{pQueueJNDIName, lQueue}, new String[]{String.class.getName(), Queue.class.getName()});
        QueueReceiver lReceiver = lSession.createReceiver(lQueue, null);
        lReceiver.setMessageListener(this);
        this.addNotificationListener(pConnector, pFilter);
    }

    public void onMessage(Message pMessage) {
        try {
            Notification lNotification = (Notification)((ObjectMessage)pMessage).getObject();
            this.mClientListener.handleNotification(lNotification, this.mHandback);
        }
        catch (JMSException e) {
            this.log.error("failed to handle notification", e);
        }
    }

    private QueueConnection getQueueConnection(String pServerName, String pQueueJNDIName) throws NamingException, JMSException {
        InitialContext lJNDIContext = null;
        if (pServerName != null) {
            Hashtable<String, String> lProperties = new Hashtable<String, String>();
            lProperties.put("java.naming.provider.url", pServerName);
            lJNDIContext = new InitialContext(lProperties);
        } else {
            lJNDIContext = new InitialContext();
        }
        Object aRef = lJNDIContext.lookup(pQueueJNDIName);
        QueueConnectionFactory aFactory = (QueueConnectionFactory)PortableRemoteObject.narrow((Object)aRef, (Class)QueueConnectionFactory.class);
        QueueConnection lConnection = aFactory.createQueueConnection();
        lConnection.start();
        return lConnection;
    }
}

