/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class FastPipedInputStream
extends PipedInputStream {
    public FastPipedInputStream() {
    }

    public FastPipedInputStream(PipedOutputStream src) throws IOException {
        super(src);
    }

    protected synchronized void receive(int b) throws IOException {
        try {
            super.receive(b);
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && message.equals("Read end dead")) {
                this.receiveAnyWay(b);
            }
            throw e;
        }
        this.notifyAll();
    }

    protected synchronized void receiveAnyWay(int b) throws IOException {
        while (this.in == this.out) {
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
        }
        if (this.in < 0) {
            this.in = 0;
            this.out = 0;
        }
        this.buffer[this.in++] = (byte)(b & 0xFF);
        if (this.in >= this.buffer.length) {
            this.in = 0;
        }
    }
}

